/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client;

import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.Listener;
import io.atomix.catalyst.util.concurrent.CatalystThreadFactory;
import io.atomix.catalyst.util.concurrent.Futures;
import io.atomix.catalyst.util.concurrent.SingleThreadContext;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.Command;
import io.atomix.copycat.Operation;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.ConnectionStrategy;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.copycat.client.RecoveryStrategy;
import io.atomix.copycat.client.RetryStrategy;
import io.atomix.copycat.client.ServerSelectionStrategy;
import io.atomix.copycat.client.session.ClientSession;
import io.atomix.copycat.client.util.AddressSelector;
import io.atomix.copycat.client.util.ClientSequencer;
import io.atomix.copycat.session.ClosedSessionException;
import io.atomix.copycat.session.Session;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCopycatClient
implements CopycatClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCopycatClient.class);
    private final Transport transport;
    private final CatalystThreadFactory threadFactory;
    private final ThreadContext context;
    private final AddressSelector selector;
    private final ConnectionStrategy connectionStrategy;
    private final RetryStrategy retryStrategy;
    private final RecoveryStrategy recoveryStrategy;
    private final ClientSequencer sequencer = new ClientSequencer();
    private ClientSession session;
    private volatile CopycatClient.State state = CopycatClient.State.CLOSED;
    private volatile CompletableFuture<CopycatClient> openFuture;
    private volatile CompletableFuture<CopycatClient> recoverFuture;
    private volatile CompletableFuture<Void> closeFuture;
    private final Map<Long, OperationFuture<?>> operations = new LinkedHashMap();
    private final Set<StateChangeListener> changeListeners = new CopyOnWriteArraySet<StateChangeListener>();
    private final Set<EventListener<?>> eventListeners = new CopyOnWriteArraySet();
    private Listener<Session.State> changeListener;

    DefaultCopycatClient(Transport transport, Collection<Address> members, Serializer serializer, CatalystThreadFactory threadFactory, ServerSelectionStrategy selectionStrategy, ConnectionStrategy connectionStrategy, RetryStrategy retryStrategy, RecoveryStrategy recoveryStrategy) {
        this(transport, members, new SingleThreadContext(threadFactory, serializer.clone()), threadFactory, selectionStrategy, connectionStrategy, retryStrategy, recoveryStrategy);
    }

    DefaultCopycatClient(Transport transport, Collection<Address> members, ThreadContext context, CatalystThreadFactory threadFactory, ServerSelectionStrategy selectionStrategy, ConnectionStrategy connectionStrategy, RetryStrategy retryStrategy, RecoveryStrategy recoveryStrategy) {
        this.transport = Assert.notNull(transport, "transport");
        this.context = Assert.notNull(context, "context");
        this.threadFactory = Assert.notNull(threadFactory, "threadFactory");
        this.selector = new AddressSelector(members, selectionStrategy);
        this.connectionStrategy = Assert.notNull(connectionStrategy, "connectionStrategy");
        this.retryStrategy = Assert.notNull(retryStrategy, "retryStrategy");
        this.recoveryStrategy = Assert.notNull(recoveryStrategy, "recoveryStrategy");
    }

    @Override
    public CopycatClient.State state() {
        return this.state;
    }

    private void setState(CopycatClient.State state) {
        if (this.state != state) {
            this.state = state;
            LOGGER.debug("State changed: {}", (Object)state);
            this.changeListeners.forEach(l -> l.accept(state));
        }
    }

    @Override
    public Listener<CopycatClient.State> onStateChange(Consumer<CopycatClient.State> callback) {
        return new StateChangeListener(callback);
    }

    @Override
    public Transport transport() {
        return this.transport;
    }

    @Override
    public Serializer serializer() {
        ThreadContext context = ThreadContext.currentContext();
        return context != null ? context.serializer() : this.context.serializer();
    }

    @Override
    public Session session() {
        return this.session;
    }

    @Override
    public ThreadContext context() {
        return this.context;
    }

    private ClientSession newSession() {
        ClientSession session = new ClientSession(this.transport.client(), this.selector, (ThreadContext)new SingleThreadContext(this.threadFactory, this.context.serializer().clone()), this.connectionStrategy, this.retryStrategy);
        if (this.changeListener != null) {
            this.changeListener.close();
        }
        this.changeListener = session.onStateChange(this::onStateChange);
        this.eventListeners.forEach(l -> l.register(session));
        return session;
    }

    private void onStateChange(Session.State state) {
        switch (state) {
            case OPEN: {
                this.setState(CopycatClient.State.CONNECTED);
                break;
            }
            case UNSTABLE: {
                this.setState(CopycatClient.State.SUSPENDED);
                break;
            }
            case EXPIRED: {
                this.setState(CopycatClient.State.SUSPENDED);
                this.recoveryStrategy.recover(this);
            }
            case CLOSED: {
                this.setState(CopycatClient.State.CLOSED);
                break;
            }
        }
    }

    @Override
    public synchronized CompletableFuture<CopycatClient> open() {
        if (this.state != CopycatClient.State.CLOSED) {
            return CompletableFuture.completedFuture(this);
        }
        if (this.openFuture == null) {
            this.openFuture = new CompletableFuture();
            this.session = this.newSession();
            this.session.open().whenCompleteAsync((result, error) -> {
                if (error == null) {
                    this.openFuture.complete(this);
                } else {
                    this.openFuture.completeExceptionally((Throwable)error);
                }
            }, this.context.executor());
        }
        return this.openFuture;
    }

    @Override
    public boolean isOpen() {
        return this.state != CopycatClient.State.CLOSED;
    }

    @Override
    public <T> CompletableFuture<T> submit(Command<T> command) {
        if (this.session == null) {
            return Futures.exceptionalFuture(new ClosedSessionException("session closed"));
        }
        OperationFuture future = new OperationFuture(command);
        this.context.executor().execute(() -> this.submit(command, this.session::submit, future));
        return future;
    }

    @Override
    public <T> CompletableFuture<T> submit(Query<T> query) {
        if (this.session == null) {
            return Futures.exceptionalFuture(new ClosedSessionException("session closed"));
        }
        OperationFuture future = new OperationFuture(query);
        this.context.executor().execute(() -> this.submit(query, this.session::submit, future));
        return future;
    }

    private <T extends Operation<U>, U> void submit(T operation, Function<T, CompletableFuture<U>> submitter, OperationFuture<U> future) {
        this.context.checkThread();
        long sequence = this.sequencer.nextSequence();
        this.operations.put(sequence, future);
        submitter.apply(operation).whenCompleteAsync((r, e) -> this.complete(sequence, (Object)r, (Throwable)e, future), this.context.executor());
    }

    private <T> void resubmit(long sequence, OperationFuture<T> future) {
        this.context.checkThread();
        this.session.submit(future.operation).whenCompleteAsync((r, e) -> this.complete(sequence, (Object)r, (Throwable)e, future), this.context.executor());
    }

    private <T> void complete(long sequence, T result, Throwable error, OperationFuture<T> future) {
        this.context.checkThread();
        this.sequencer.sequence(sequence, () -> {
            if (error == null) {
                this.operations.remove(sequence);
                future.complete(result);
            } else if (!(error instanceof ClosedSessionException)) {
                this.operations.remove(sequence);
                future.completeExceptionally(error);
            }
        });
    }

    @Override
    public Listener<Void> onEvent(String event, Runnable callback) {
        return this.onEvent(event, (T v) -> callback.run());
    }

    @Override
    public <T> Listener<T> onEvent(String event, Consumer<T> callback) {
        EventListener listener = new EventListener(event, callback);
        listener.register(this.session);
        return listener;
    }

    @Override
    public synchronized CompletableFuture<CopycatClient> recover() {
        if (this.recoverFuture == null) {
            LOGGER.debug("Recovering session {}", (Object)this.session.id());
            ClientSession session = this.newSession();
            this.recoverFuture = ((CompletableFuture)session.open().handleAsync((result, error) -> {
                if (error == null) {
                    LOGGER.debug("Recovered by replacing session {} with session {}", (Object)this.session.id(), (Object)session.id());
                    ClientSession oldSession = this.session;
                    this.session = session;
                    for (Map.Entry<Long, OperationFuture<?>> entry : this.operations.entrySet()) {
                        this.resubmit(entry.getKey(), entry.getValue());
                    }
                    return oldSession.close();
                }
                this.setState(CopycatClient.State.CLOSED);
                return Futures.exceptionalFuture(error);
            }, this.context.executor())).thenApply(v -> this);
        }
        return this.recoverFuture;
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        if (this.state == CopycatClient.State.CLOSED) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.closeFuture == null) {
            this.closeFuture = new CompletableFuture();
            this.session.close().whenCompleteAsync((result, error) -> {
                this.setState(CopycatClient.State.CLOSED);
                for (Map.Entry<Long, OperationFuture<?>> entry : this.operations.entrySet()) {
                    entry.getValue().completeExceptionally(new ClosedSessionException("session closed"));
                }
                CompletableFuture.runAsync(() -> {
                    this.context.close();
                    this.transport.close();
                    if (error == null) {
                        this.closeFuture.complete(null);
                    } else {
                        this.closeFuture.completeExceptionally((Throwable)error);
                    }
                });
            }, this.context.executor());
        }
        return this.closeFuture;
    }

    @Override
    public boolean isClosed() {
        return this.state == CopycatClient.State.CLOSED;
    }

    public synchronized CompletableFuture<Void> kill() {
        if (this.state == CopycatClient.State.CLOSED) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.closeFuture == null) {
            this.closeFuture = this.session.kill().whenComplete((result, error) -> {
                this.setState(CopycatClient.State.CLOSED);
                CompletableFuture.runAsync(() -> {
                    this.context.close();
                    this.transport.close();
                });
            });
        }
        return this.closeFuture;
    }

    public int hashCode() {
        return 23 + 37 * (this.session != null ? this.session.hashCode() : 0);
    }

    public boolean equals(Object object) {
        return object instanceof DefaultCopycatClient && ((DefaultCopycatClient)object).session() == this.session;
    }

    public String toString() {
        return String.format("%s[session=%s]", this.getClass().getSimpleName(), this.session);
    }

    private final class EventListener<T>
    implements Listener<T> {
        private final String event;
        private final Consumer<T> callback;
        private Listener<T> parent;

        private EventListener(String event, Consumer<T> callback) {
            this.event = event;
            this.callback = callback;
            DefaultCopycatClient.this.eventListeners.add(this);
        }

        public void register(ClientSession session) {
            if (ThreadContext.currentContext() == DefaultCopycatClient.this.context) {
                this.parent = session.onEvent(this.event, this.callback);
            } else {
                DefaultCopycatClient.this.context.execute(() -> {
                    this.parent = session.onEvent(this.event, this.callback);
                }).join();
            }
        }

        @Override
        public void accept(T message) {
            DefaultCopycatClient.this.context.executor().execute(() -> this.callback.accept(message));
        }

        @Override
        public void close() {
            this.parent.close();
            DefaultCopycatClient.this.eventListeners.remove(this);
        }
    }

    private final class StateChangeListener
    implements Listener<CopycatClient.State> {
        private final Consumer<CopycatClient.State> callback;

        protected StateChangeListener(Consumer<CopycatClient.State> callback) {
            this.callback = callback;
            DefaultCopycatClient.this.changeListeners.add(this);
        }

        @Override
        public void accept(CopycatClient.State state) {
            DefaultCopycatClient.this.context.executor().execute(() -> this.callback.accept(state));
        }

        @Override
        public void close() {
            DefaultCopycatClient.this.changeListeners.remove(this);
        }
    }

    private static final class OperationFuture<T>
    extends CompletableFuture<T> {
        private final Operation<T> operation;

        private OperationFuture(Operation<T> operation) {
            this.operation = operation;
        }
    }
}

