/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client;

import io.atomix.copycat.client.RetryStrategy;
import java.time.Duration;

public enum RetryStrategies implements RetryStrategy
{
    FAIL{

        @Override
        public void attemptFailed(RetryStrategy.Attempt attempt, Throwable cause) {
            attempt.fail(cause);
        }
    }
    ,
    RETRY{

        @Override
        public void attemptFailed(RetryStrategy.Attempt attempt, Throwable cause) {
            attempt.retry();
        }
    }
    ,
    EXPONENTIAL_BACKOFF{

        @Override
        public void attemptFailed(RetryStrategy.Attempt attempt, Throwable cause) {
            attempt.retry(Duration.ofSeconds(Math.min(Math.round(Math.pow(2.0, attempt.attempt())), 5L)));
        }
    }
    ,
    FIBONACCI_BACKOFF{
        private final int[] FIBONACCI = new int[]{1, 1, 2, 3, 5};

        @Override
        public void attemptFailed(RetryStrategy.Attempt attempt, Throwable cause) {
            attempt.retry(Duration.ofSeconds(this.FIBONACCI[Math.min(attempt.attempt() - 1, this.FIBONACCI.length - 1)]));
        }
    };

}

