/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client.session;

import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.Listener;
import io.atomix.catalyst.util.Managed;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.Command;
import io.atomix.copycat.Operation;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.ConnectionStrategy;
import io.atomix.copycat.client.RetryStrategy;
import io.atomix.copycat.client.session.ClientSessionListener;
import io.atomix.copycat.client.session.ClientSessionManager;
import io.atomix.copycat.client.session.ClientSessionState;
import io.atomix.copycat.client.session.ClientSessionSubmitter;
import io.atomix.copycat.client.util.AddressSelector;
import io.atomix.copycat.client.util.ClientConnection;
import io.atomix.copycat.session.Session;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class ClientSession
implements Session,
Managed<Session> {
    private final ClientSessionState state;
    private final ThreadContext context;
    private final ClientConnection connection;
    private final ClientSessionManager manager;
    private final ClientSessionListener listener;
    private final ClientSessionSubmitter submitter;

    public ClientSession(Client client, AddressSelector selector, ThreadContext context, ConnectionStrategy connectionStrategy, RetryStrategy retryStrategy) {
        this(UUID.randomUUID(), client, selector, context, connectionStrategy, retryStrategy);
    }

    public ClientSession(UUID id, Client client, AddressSelector selector, ThreadContext context, ConnectionStrategy connectionStrategy, RetryStrategy retryStrategy) {
        this(new ClientConnection(id, client, selector), new ClientSessionState(id), context, connectionStrategy, retryStrategy);
    }

    private ClientSession(ClientConnection connection, ClientSessionState state, ThreadContext context, ConnectionStrategy connectionStrategy, RetryStrategy retryStrategy) {
        this.connection = Assert.notNull(connection, "connection");
        this.state = Assert.notNull(state, "state");
        this.context = Assert.notNull(context, "context");
        this.manager = new ClientSessionManager(connection, state, context, connectionStrategy);
        this.listener = new ClientSessionListener(connection, state, context);
        this.submitter = new ClientSessionSubmitter(connection, state, context, retryStrategy);
    }

    @Override
    public long id() {
        return this.state.getSessionId();
    }

    @Override
    public Session.State state() {
        return this.state.getState();
    }

    @Override
    public Listener<Session.State> onStateChange(Consumer<Session.State> callback) {
        return this.state.onStateChange(callback);
    }

    public <T> CompletableFuture<T> submit(Operation<T> operation) {
        if (operation instanceof Query) {
            return this.submit((Query)operation);
        }
        if (operation instanceof Command) {
            return this.submit((Command)operation);
        }
        throw new UnsupportedOperationException("unknown operation type: " + operation.getClass());
    }

    public <T> CompletableFuture<T> submit(Command<T> command) {
        return this.submitter.submit(command);
    }

    public <T> CompletableFuture<T> submit(Query<T> query) {
        return this.submitter.submit(query);
    }

    @Override
    public CompletableFuture<Session> open() {
        return this.manager.open().thenApply(v -> this);
    }

    @Override
    public boolean isOpen() {
        return this.state.getState() == Session.State.OPEN || this.state.getState() == Session.State.UNSTABLE;
    }

    public Listener<Void> onEvent(String event, Runnable callback) {
        return this.listener.onEvent(event, callback);
    }

    public <T> Listener<T> onEvent(String event, Consumer<T> callback) {
        return this.listener.onEvent(event, callback);
    }

    @Override
    public CompletableFuture<Void> close() {
        ThreadContext context = ThreadContext.currentContext();
        if (context != null) {
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.submitter.close().thenCompose(v -> this.listener.close())).thenCompose(v -> this.manager.close())).thenCompose(v -> this.connection.close())).whenCompleteAsync((result, error) -> this.context.close(), context.executor());
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.submitter.close().thenCompose(v -> this.listener.close())).thenCompose(v -> this.manager.close())).thenCompose(v -> this.connection.close())).whenCompleteAsync((result, error) -> this.context.close());
    }

    public CompletableFuture<Void> kill() {
        ThreadContext context = ThreadContext.currentContext();
        if (context != null) {
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.submitter.close().thenCompose(v -> this.listener.close())).thenCompose(v -> this.manager.kill())).thenCompose(v -> this.connection.close())).whenCompleteAsync((result, error) -> this.context.close(), context.executor());
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.submitter.close().thenCompose(v -> this.listener.close())).thenCompose(v -> this.manager.kill())).thenCompose(v -> this.connection.close())).whenCompleteAsync((result, error) -> this.context.close());
    }

    @Override
    public boolean isClosed() {
        return this.state.getState() == Session.State.EXPIRED || this.state.getState() == Session.State.CLOSED;
    }

    public int hashCode() {
        int hashCode = 31;
        long id = this.id();
        hashCode = 37 * hashCode + (int)(id ^ id >>> 32);
        return hashCode;
    }

    public boolean equals(Object object) {
        return object instanceof ClientSession && ((ClientSession)object).id() == this.id();
    }

    public String toString() {
        return String.format("%s[id=%d]", this.getClass().getSimpleName(), this.id());
    }
}

