/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client.session;

import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.Listener;
import io.atomix.copycat.client.session.ClientSession;
import io.atomix.copycat.session.Session;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientSessionState {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientSession.class);
    private final UUID clientId;
    private volatile long sessionId;
    private volatile Session.State state = Session.State.CLOSED;
    private long commandRequest;
    private long commandResponse;
    private long responseIndex;
    private long eventIndex;
    private long completeIndex;
    private final Set<Listener<Session.State>> changeListeners = new CopyOnWriteArraySet<Listener<Session.State>>();

    ClientSessionState(UUID clientId) {
        this.clientId = Assert.notNull(clientId, "clientId");
    }

    public UUID getClientId() {
        return this.clientId;
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public ClientSessionState setSessionId(long sessionId) {
        this.sessionId = sessionId;
        this.responseIndex = sessionId;
        this.eventIndex = sessionId;
        this.completeIndex = sessionId;
        return this;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public Session.State getState() {
        return this.state;
    }

    public ClientSessionState setState(Session.State state) {
        if (this.state != state) {
            this.state = state;
            this.changeListeners.forEach(l -> l.accept(state));
        }
        return this;
    }

    public Listener<Session.State> onStateChange(final Consumer<Session.State> callback) {
        Listener<Session.State> listener = new Listener<Session.State>(){

            @Override
            public void accept(Session.State state) {
                callback.accept(state);
            }

            @Override
            public void close() {
                ClientSessionState.this.changeListeners.remove(this);
            }
        };
        this.changeListeners.add(listener);
        return listener;
    }

    public ClientSessionState setCommandRequest(long commandRequest) {
        this.commandRequest = commandRequest;
        return this;
    }

    public long getCommandRequest() {
        return this.commandRequest;
    }

    public long nextCommandRequest() {
        return ++this.commandRequest;
    }

    public ClientSessionState setCommandResponse(long commandResponse) {
        this.commandResponse = commandResponse;
        return this;
    }

    public long getCommandResponse() {
        return this.commandResponse;
    }

    public ClientSessionState setResponseIndex(long responseIndex) {
        this.responseIndex = Math.max(this.responseIndex, responseIndex);
        return this;
    }

    public long getResponseIndex() {
        return this.responseIndex;
    }

    public ClientSessionState setEventIndex(long eventIndex) {
        this.eventIndex = eventIndex;
        return this;
    }

    public long getEventIndex() {
        return this.eventIndex;
    }

    public ClientSessionState setCompleteIndex(long completeIndex) {
        this.completeIndex = Math.max(this.completeIndex, completeIndex);
        return this;
    }

    public long getCompleteIndex() {
        return this.completeIndex;
    }
}

