/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client.session;

import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.Command;
import io.atomix.copycat.NoOpCommand;
import io.atomix.copycat.Operation;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.RetryStrategy;
import io.atomix.copycat.client.session.ClientSessionState;
import io.atomix.copycat.client.util.ClientSequencer;
import io.atomix.copycat.error.CommandException;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.error.QueryException;
import io.atomix.copycat.protocol.AbstractResponse;
import io.atomix.copycat.protocol.CommandRequest;
import io.atomix.copycat.protocol.CommandResponse;
import io.atomix.copycat.protocol.OperationRequest;
import io.atomix.copycat.protocol.OperationResponse;
import io.atomix.copycat.protocol.QueryRequest;
import io.atomix.copycat.protocol.QueryResponse;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.session.ClosedSessionException;
import io.atomix.copycat.session.Session;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

final class ClientSessionSubmitter {
    private final Connection connection;
    private final ClientSessionState state;
    private final ThreadContext context;
    private final RetryStrategy strategy;
    private final ClientSequencer sequencer = new ClientSequencer();

    public ClientSessionSubmitter(Connection connection, ClientSessionState state, ThreadContext context, RetryStrategy retryStrategy) {
        this.connection = Assert.notNull(connection, "connection");
        this.state = Assert.notNull(state, "state");
        this.context = Assert.notNull(context, "context");
        this.strategy = Assert.notNull(retryStrategy, "retryStrategy");
    }

    public <T> CompletableFuture<T> submit(Command<T> command) {
        CompletableFuture future = new CompletableFuture();
        this.context.executor().execute(() -> this.submitCommand(command, future));
        return future;
    }

    private <T> void submitCommand(Command<T> command, CompletableFuture<T> future) {
        CommandRequest request = ((CommandRequest.Builder)((CommandRequest.Builder)CommandRequest.builder().withSession(this.state.getSessionId())).withSequence(this.state.nextCommandRequest())).withCommand(command).build();
        this.submitCommand(request, future);
    }

    private <T> void submitCommand(CommandRequest request, CompletableFuture<T> future) {
        this.submit(new CommandAttempt<T>(this.sequencer.nextSequence(), request, future));
    }

    public <T> CompletableFuture<T> submit(Query<T> query) {
        CompletableFuture future = new CompletableFuture();
        this.context.executor().execute(() -> this.submitQuery(query, future));
        return future;
    }

    private <T> void submitQuery(Query<T> query, CompletableFuture<T> future) {
        if (query.consistency() == Query.ConsistencyLevel.CAUSAL) {
            QueryRequest request = ((QueryRequest.Builder)((QueryRequest.Builder)QueryRequest.builder().withSession(this.state.getSessionId())).withSequence(this.state.getCommandResponse())).withIndex(this.state.getResponseIndex()).withQuery(query).build();
            this.submitQuery(request, future);
        } else {
            QueryRequest request = ((QueryRequest.Builder)((QueryRequest.Builder)QueryRequest.builder().withSession(this.state.getSessionId())).withSequence(this.state.getCommandRequest())).withIndex(this.state.getResponseIndex()).withQuery(query).build();
            this.submitQuery(request, future);
        }
    }

    private <T> void submitQuery(QueryRequest request, CompletableFuture<T> future) {
        this.submit(new QueryAttempt<T>(this.sequencer.nextSequence(), request, future));
    }

    private <T extends OperationRequest, U extends OperationResponse, V> void submit(OperationAttempt<T, U, V> attempt) {
        if (this.state.getState() == Session.State.CLOSED || this.state.getState() == Session.State.EXPIRED) {
            attempt.fail(new ClosedSessionException("session closed"));
        } else {
            this.state.getLogger().debug("{} - Sending {}", (Object)this.state.getSessionId(), attempt.request);
            this.connection.send(attempt.request).whenComplete(attempt);
        }
    }

    public CompletableFuture<Void> close() {
        return CompletableFuture.completedFuture(null);
    }

    private final class QueryAttempt<T>
    extends OperationAttempt<QueryRequest, QueryResponse, T> {
        public QueryAttempt(long sequence, QueryRequest request, CompletableFuture<T> future) {
            super(ClientSessionSubmitter.this, sequence, 1, (OperationRequest)request, future);
        }

        public QueryAttempt(long sequence, int attempt, QueryRequest request, CompletableFuture<T> future) {
            super(ClientSessionSubmitter.this, sequence, attempt, (OperationRequest)request, future);
        }

        @Override
        protected OperationAttempt<QueryRequest, QueryResponse, T> next() {
            return new QueryAttempt<T>(this.sequence, this.attempt + 1, (QueryRequest)this.request, this.future);
        }

        @Override
        protected Throwable defaultException() {
            return new QueryException("failed to complete query", new Object[0]);
        }

        @Override
        protected void complete(QueryResponse response) {
            if (((QueryRequest)this.request).query().consistency() == Query.ConsistencyLevel.CAUSAL) {
                this.sequence(() -> {
                    ClientSessionSubmitter.this.state.setResponseIndex(response.index());
                    this.future.complete(response.result());
                });
            } else if (response.index() > 0L && response.index() < ClientSessionSubmitter.this.state.getResponseIndex()) {
                this.retry();
            } else {
                this.sequence(() -> {
                    ClientSessionSubmitter.this.state.setResponseIndex(response.index());
                    this.future.complete(response.result());
                });
            }
        }

        @Override
        protected void complete(Throwable error) {
            this.future.completeExceptionally(error);
        }
    }

    private final class CommandAttempt<T>
    extends OperationAttempt<CommandRequest, CommandResponse, T> {
        public CommandAttempt(long sequence, CommandRequest request, CompletableFuture<T> future) {
            super(ClientSessionSubmitter.this, sequence, 1, (OperationRequest)request, future);
        }

        public CommandAttempt(long sequence, int attempt, CommandRequest request, CompletableFuture<T> future) {
            super(ClientSessionSubmitter.this, sequence, attempt, (OperationRequest)request, future);
        }

        @Override
        protected OperationAttempt<CommandRequest, CommandResponse, T> next() {
            return new CommandAttempt<T>(this.sequence, this.attempt + 1, (CommandRequest)this.request, this.future);
        }

        @Override
        protected Throwable defaultException() {
            return new CommandException("failed to complete command", new Object[0]);
        }

        @Override
        public void fail(Throwable t) {
            super.fail(t);
            CommandRequest request = ((CommandRequest.Builder)((CommandRequest.Builder)CommandRequest.builder().withSession(((CommandRequest)this.request).session())).withSequence(((CommandRequest)this.request).sequence())).withCommand(new NoOpCommand()).build();
            ClientSessionSubmitter.this.context.executor().execute(() -> ClientSessionSubmitter.this.submit(new CommandAttempt<T>(this.sequence, this.attempt + 1, request, this.future)));
        }

        @Override
        protected void complete(CommandResponse response) {
            this.sequence(() -> {
                ClientSessionSubmitter.this.state.setCommandResponse(((CommandRequest)this.request).sequence());
                ClientSessionSubmitter.this.state.setResponseIndex(response.index());
                this.future.complete(response.result());
            });
        }

        @Override
        protected void complete(Throwable error) {
            this.sequence(() -> this.future.completeExceptionally(error));
        }
    }

    private abstract class OperationAttempt<T extends OperationRequest, U extends OperationResponse, V>
    implements RetryStrategy.Attempt,
    BiConsumer<U, Throwable> {
        protected final long sequence;
        protected final int attempt;
        protected final T request;
        protected final CompletableFuture<V> future;
        final /* synthetic */ ClientSessionSubmitter this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        protected OperationAttempt(long attempt, int future, T t, CompletableFuture<V> completableFuture) {
            void request;
            void sequence;
            this.this$0 = (ClientSessionSubmitter)l;
            this.sequence = sequence;
            this.attempt = (int)attempt;
            this.request = request;
            this.future = (CompletableFuture<V>)future;
        }

        @Override
        public int attempt() {
            return this.attempt;
        }

        @Override
        public Operation<?> operation() {
            return ((OperationRequest)this.request).operation();
        }

        @Override
        public void accept(U response, Throwable error) {
            if (error == null) {
                this.this$0.state.getLogger().debug("{} - Received {}", (Object)this.this$0.state.getSessionId(), response);
                if (((AbstractResponse)response).status() == Response.Status.OK) {
                    this.complete(response);
                } else if (((AbstractResponse)response).error() == CopycatError.Type.COMMAND_ERROR || ((AbstractResponse)response).error() == CopycatError.Type.QUERY_ERROR || ((AbstractResponse)response).error() == CopycatError.Type.APPLICATION_ERROR) {
                    this.complete(((AbstractResponse)response).error().createException());
                } else if (((AbstractResponse)response).error() != CopycatError.Type.UNKNOWN_SESSION_ERROR) {
                    this.this$0.strategy.attemptFailed(this, ((AbstractResponse)response).error().createException());
                }
            } else {
                this.this$0.strategy.attemptFailed(this, error);
            }
        }

        protected abstract OperationAttempt<T, U, V> next();

        protected abstract Throwable defaultException();

        protected abstract void complete(U var1);

        protected abstract void complete(Throwable var1);

        protected final void sequence(Runnable callback) {
            this.this$0.sequencer.sequence(this.sequence, callback);
        }

        @Override
        public void fail() {
            this.fail(this.defaultException());
        }

        @Override
        public void fail(Throwable t) {
            this.complete(t);
        }

        @Override
        public void retry() {
            this.this$0.context.executor().execute(() -> this.this$0.submit(this.next()));
        }

        @Override
        public void retry(Duration after) {
            this.this$0.context.schedule(after, () -> this.this$0.submit(this.next()));
        }
    }
}

