/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.SessionRequest;
import java.util.Objects;

public class KeepAliveRequest
extends SessionRequest {
    private long commandSequence;
    private long eventIndex;

    public static Builder builder() {
        return new Builder(new KeepAliveRequest());
    }

    public static Builder builder(KeepAliveRequest request) {
        return new Builder(request);
    }

    public long commandSequence() {
        return this.commandSequence;
    }

    public long eventIndex() {
        return this.eventIndex;
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.commandSequence = buffer.readLong();
        this.eventIndex = buffer.readLong();
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeLong(this.commandSequence);
        buffer.writeLong(this.eventIndex);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.session, this.commandSequence);
    }

    public boolean equals(Object object) {
        if (object instanceof KeepAliveRequest) {
            KeepAliveRequest request = (KeepAliveRequest)object;
            return request.session == this.session && request.commandSequence == this.commandSequence && request.eventIndex == this.eventIndex;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[session=%d, commandSequence=%d, eventIndex=%d]", this.getClass().getSimpleName(), this.session, this.commandSequence, this.eventIndex);
    }

    public static class Builder
    extends SessionRequest.Builder<Builder, KeepAliveRequest> {
        protected Builder(KeepAliveRequest request) {
            super(request);
        }

        public Builder withCommandSequence(long commandSequence) {
            ((KeepAliveRequest)this.request).commandSequence = Assert.argNot(commandSequence, commandSequence < 0L, "commandSequence cannot be negative", new Object[0]);
            return this;
        }

        public Builder withEventIndex(long eventIndex) {
            ((KeepAliveRequest)this.request).eventIndex = Assert.argNot(eventIndex, eventIndex < 0L, "eventIndex cannot be negative", new Object[0]);
            return this;
        }

        @Override
        public KeepAliveRequest build() {
            super.build();
            Assert.state(((KeepAliveRequest)this.request).session > 0L, "session must be positive", new Object[0]);
            return (KeepAliveRequest)this.request;
        }
    }
}

