/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.protocol.SessionResponse;
import java.util.Objects;

public abstract class OperationResponse
extends SessionResponse {
    protected long index;
    protected Object result;

    public long index() {
        return this.index;
    }

    public Object result() {
        return this.result;
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.status = Response.Status.forId(buffer.readByte());
        this.index = buffer.readLong();
        if (this.status == Response.Status.OK) {
            this.error = null;
            this.result = serializer.readObject(buffer);
        } else {
            this.error = CopycatError.forId(buffer.readByte());
        }
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeByte(this.status.id()).writeLong(this.index);
        if (this.status == Response.Status.OK) {
            serializer.writeObject(this.result, buffer);
        } else {
            buffer.writeByte(this.error.id());
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status, this.result});
    }

    public boolean equals(Object object) {
        if (this.getClass().isAssignableFrom(object.getClass())) {
            OperationResponse response = (OperationResponse)object;
            return response.status == this.status && response.index == this.index && (response.result == null && this.result == null || response.result != null && this.result != null && response.result.equals(this.result));
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[status=%s, index=%d, result=%s]", new Object[]{this.getClass().getSimpleName(), this.status, this.index, this.result});
    }

    public static abstract class Builder<T extends Builder<T, U>, U extends OperationResponse>
    extends SessionResponse.Builder<T, U> {
        protected Builder(U response) {
            super(response);
        }

        public T withIndex(long index) {
            ((OperationResponse)this.response).index = Assert.argNot(index, index < 0L, "index must be positive", new Object[0]);
            return (T)this;
        }

        public T withResult(Object result) {
            ((OperationResponse)this.response).result = result;
            return (T)this;
        }

        @Override
        public U build() {
            super.build();
            if (((OperationResponse)this.response).status == Response.Status.OK) {
                Assert.stateNot(((OperationResponse)this.response).index < 0L, "index cannot be less than 0", new Object[0]);
            }
            return (U)((OperationResponse)this.response);
        }
    }
}

