/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.SessionRequest;
import io.atomix.copycat.session.Event;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PublishRequest
extends SessionRequest {
    private long eventIndex;
    private long previousIndex;
    private List<Event<?>> events = new ArrayList(8);

    public static Builder builder() {
        return new Builder(new PublishRequest());
    }

    public static Builder builder(PublishRequest request) {
        return new Builder(request);
    }

    public long eventIndex() {
        return this.eventIndex;
    }

    public long previousIndex() {
        return this.previousIndex;
    }

    public List<Event<?>> events() {
        return this.events;
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.eventIndex = buffer.readLong();
        this.previousIndex = buffer.readLong();
        this.events.clear();
        int size = buffer.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            this.events.add((Event<?>)serializer.readObject(buffer));
        }
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeLong(this.eventIndex);
        buffer.writeLong(this.previousIndex);
        buffer.writeUnsignedShort(this.events.size());
        for (Event<?> event : this.events) {
            serializer.writeObject(event, buffer);
        }
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.session, this.eventIndex, this.previousIndex, this.events);
    }

    public boolean equals(Object object) {
        if (object instanceof PublishRequest) {
            PublishRequest request = (PublishRequest)object;
            return request.session == this.session && request.eventIndex == this.eventIndex && request.previousIndex == this.previousIndex && request.events.equals(this.events);
        }
        return false;
    }

    public String toString() {
        return String.format("%s[session=%d, eventIndex=%d, previousIndex=%d, events=%s]", this.getClass().getSimpleName(), this.session, this.eventIndex, this.previousIndex, this.events);
    }

    public static class Builder
    extends SessionRequest.Builder<Builder, PublishRequest> {
        protected Builder(PublishRequest request) {
            super(request);
        }

        public Builder withEventIndex(long index) {
            ((PublishRequest)this.request).eventIndex = Assert.argNot(index, index < 1L, "index cannot be less than 1", new Object[0]);
            return this;
        }

        public Builder withPreviousIndex(long index) {
            ((PublishRequest)this.request).previousIndex = Assert.argNot(index, index < 0L, "index cannot be less than 0", new Object[0]);
            return this;
        }

        public Builder withEvents(Event<?> ... events) {
            return this.withEvents(Arrays.asList((Object[])Assert.notNull(events, "events")));
        }

        public Builder withEvents(List<Event<?>> events) {
            ((PublishRequest)this.request).events = events;
            return this;
        }

        @Override
        public PublishRequest build() {
            super.build();
            Assert.stateNot(((PublishRequest)this.request).eventIndex < 0L, "eventIndex cannot be less than 0", new Object[0]);
            Assert.stateNot(((PublishRequest)this.request).previousIndex < -1L, "previousIndex cannot be less than -1", new Object[0]);
            Assert.stateNot(((PublishRequest)this.request).events == null, "events cannot be null", new Object[0]);
            return (PublishRequest)this.request;
        }
    }
}

