/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server;

import io.atomix.catalyst.buffer.PooledHeapAllocator;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.Server;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.ConfigurationException;
import io.atomix.catalyst.util.Listener;
import io.atomix.catalyst.util.Managed;
import io.atomix.catalyst.util.concurrent.Futures;
import io.atomix.catalyst.util.concurrent.SingleThreadContext;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.protocol.ClientRequestTypeResolver;
import io.atomix.copycat.protocol.ClientResponseTypeResolver;
import io.atomix.copycat.server.StateMachine;
import io.atomix.copycat.server.cluster.Cluster;
import io.atomix.copycat.server.cluster.Member;
import io.atomix.copycat.server.protocol.ServerRequestTypeResolver;
import io.atomix.copycat.server.protocol.ServerResponseTypeResolver;
import io.atomix.copycat.server.state.ConnectionManager;
import io.atomix.copycat.server.state.ServerContext;
import io.atomix.copycat.server.state.StateTypeResolver;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.server.storage.entry.EntryTypeResolver;
import io.atomix.copycat.session.SessionTypeResolver;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopycatServer
implements Managed<CopycatServer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopycatServer.class);
    private final String name;
    private final Transport clientTransport;
    private final Transport serverTransport;
    private final Server clientServer;
    private final Server internalServer;
    private final ServerContext context;
    private volatile CompletableFuture<CopycatServer> openFuture;
    private volatile CompletableFuture<Void> closeFuture;
    private Listener<Member> electionListener;
    private boolean open;

    public static Builder builder(Address address, Address ... cluster) {
        return CopycatServer.builder(address, address, Arrays.asList(cluster));
    }

    public static Builder builder(Address address, Collection<Address> cluster) {
        return new Builder(address, address, cluster);
    }

    public static Builder builder(Member.Type type, Address address, Address ... cluster) {
        return CopycatServer.builder(address, address, Arrays.asList(cluster)).withType(type);
    }

    public static Builder builder(Member.Type type, Address address, Collection<Address> cluster) {
        return new Builder(address, address, cluster).withType(type);
    }

    public static Builder builder(Address clientAddress, Address serverAddress, Address ... cluster) {
        return CopycatServer.builder(clientAddress, serverAddress, Arrays.asList(cluster));
    }

    public static Builder builder(Address clientAddress, Address serverAddress, Collection<Address> cluster) {
        return new Builder(clientAddress, serverAddress, cluster);
    }

    public static Builder builder(Member.Type type, Address clientAddress, Address serverAddress, Address ... cluster) {
        return CopycatServer.builder(clientAddress, serverAddress, Arrays.asList(cluster)).withType(type);
    }

    public static Builder builder(Member.Type type, Address clientAddress, Address serverAddress, Collection<Address> cluster) {
        return new Builder(clientAddress, serverAddress, cluster).withType(type);
    }

    private CopycatServer(String name, Transport clientTransport, Transport serverTransport, ServerContext context) {
        this.name = Assert.notNull(name, "name");
        this.clientTransport = Assert.notNull(clientTransport, "clientTransport");
        this.serverTransport = Assert.notNull(serverTransport, "serverTransport");
        this.internalServer = serverTransport.server();
        this.clientServer = !context.getCluster().member().serverAddress().equals(context.getCluster().member().clientAddress()) ? clientTransport.server() : null;
        this.context = Assert.notNull(context, "context");
    }

    public String name() {
        return this.name;
    }

    public Storage storage() {
        return this.context.getStorage();
    }

    public Cluster cluster() {
        return this.context.getCluster();
    }

    public Serializer serializer() {
        return this.context.getSerializer();
    }

    public State state() {
        return this.context.getState();
    }

    public Listener<State> onStateChange(Consumer<State> listener) {
        return this.context.onStateChange(listener);
    }

    public ThreadContext context() {
        return this.context.getThreadContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<CopycatServer> open() {
        if (this.open) {
            return CompletableFuture.completedFuture(this);
        }
        if (this.openFuture == null) {
            CopycatServer copycatServer = this;
            synchronized (copycatServer) {
                if (this.openFuture == null) {
                    Function<Void, CompletionStage> completionFunction = state -> {
                        CompletableFuture future = new CompletableFuture();
                        this.openFuture = null;
                        this.cluster().join().whenComplete((result, error) -> {
                            if (error == null) {
                                if (this.cluster().leader() != null) {
                                    this.open = true;
                                    future.complete(this);
                                } else {
                                    this.electionListener = this.cluster().onLeaderElection(leader -> {
                                        if (this.electionListener != null) {
                                            this.open = true;
                                            future.complete(this);
                                            this.electionListener.close();
                                            this.electionListener = null;
                                        }
                                    });
                                }
                            } else {
                                future.completeExceptionally((Throwable)error);
                            }
                        });
                        return future;
                    };
                    this.openFuture = this.closeFuture == null ? this.listen().thenCompose(completionFunction) : this.closeFuture.thenCompose(c -> this.listen().thenCompose(completionFunction));
                }
            }
        }
        return this.openFuture.whenComplete((result, error) -> {
            if (error == null) {
                LOGGER.info("Server started successfully!");
            } else {
                LOGGER.warn("Failed to start server!");
            }
        });
    }

    private CompletableFuture<Void> listen() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.context.getThreadContext().executor().execute(() -> this.internalServer.listen(this.cluster().member().serverAddress(), c -> this.context.connectServer((Connection)c)).whenComplete((internalResult, internalError) -> {
            if (internalError == null) {
                if (this.clientServer != null) {
                    this.clientServer.listen(this.cluster().member().clientAddress(), c -> this.context.connectClient((Connection)c)).whenComplete((clientResult, clientError) -> {
                        this.open = true;
                        future.complete(null);
                    });
                } else {
                    this.open = true;
                    future.complete(null);
                }
            } else {
                future.completeExceptionally((Throwable)internalError);
            }
        }));
        return future;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> close() {
        if (!this.open) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.closeFuture == null) {
            CopycatServer copycatServer = this;
            synchronized (copycatServer) {
                if (this.closeFuture == null) {
                    this.closeFuture = this.openFuture == null ? this.cluster().leave().thenCompose(v -> this.kill()) : this.openFuture.thenCompose(c -> this.cluster().leave().thenCompose(v -> this.kill()));
                }
            }
        }
        return this.closeFuture;
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }

    public CompletableFuture<Void> kill() {
        if (!this.open) {
            return Futures.exceptionalFuture(new IllegalStateException("context not open"));
        }
        CompletableFuture future = new CompletableFuture();
        this.context.getThreadContext().executor().execute(() -> {
            this.open = false;
            if (this.clientServer != null) {
                this.clientServer.close().whenCompleteAsync((clientResult, clientError) -> this.internalServer.close().whenCompleteAsync((internalResult, internalError) -> {
                    if (internalError != null) {
                        future.completeExceptionally((Throwable)internalError);
                    } else if (clientError != null) {
                        future.completeExceptionally((Throwable)clientError);
                    } else {
                        future.complete(null);
                    }
                }, this.context.getThreadContext().executor()), this.context.getThreadContext().executor());
            } else {
                this.internalServer.close().whenCompleteAsync((internalResult, internalError) -> {
                    if (internalError != null) {
                        future.completeExceptionally((Throwable)internalError);
                    } else {
                        future.complete(null);
                    }
                }, this.context.getThreadContext().executor());
            }
            this.context.transition(State.INACTIVE);
        });
        return future.whenCompleteAsync((result, error) -> {
            this.clientTransport.close();
            this.serverTransport.close();
            this.context.close();
            this.open = false;
        });
    }

    public CompletableFuture<Void> delete() {
        return this.close().thenRun(this.context::delete);
    }

    public static class Builder
    implements io.atomix.catalyst.util.Builder<CopycatServer> {
        private static final String DEFAULT_NAME = "copycat";
        private static final Duration DEFAULT_ELECTION_TIMEOUT = Duration.ofMillis(750L);
        private static final Duration DEFAULT_HEARTBEAT_INTERVAL = Duration.ofMillis(250L);
        private static final Duration DEFAULT_SESSION_TIMEOUT = Duration.ofMillis(5000L);
        private static final Duration DEFAULT_GLOBAL_SUSPEND_TIMEOUT = Duration.ofHours(1L);
        private String name = "copycat";
        private Member.Type type = Member.Type.ACTIVE;
        private Transport clientTransport;
        private Transport serverTransport;
        private Storage storage;
        private Serializer serializer;
        private Supplier<StateMachine> stateMachineFactory;
        private Address clientAddress;
        private Address serverAddress;
        private Set<Address> cluster;
        private Duration electionTimeout = DEFAULT_ELECTION_TIMEOUT;
        private Duration heartbeatInterval = DEFAULT_HEARTBEAT_INTERVAL;
        private Duration sessionTimeout = DEFAULT_SESSION_TIMEOUT;
        private Duration globalSuspendTimeout = DEFAULT_GLOBAL_SUSPEND_TIMEOUT;

        private Builder(Address clientAddress, Address serverAddress, Collection<Address> cluster) {
            this.clientAddress = Assert.notNull(clientAddress, "clientAddress");
            this.serverAddress = Assert.notNull(serverAddress, "serverAddress");
            this.cluster = new HashSet<Address>(Assert.notNull(cluster, "cluster"));
            this.type = cluster.contains(serverAddress) ? Member.Type.ACTIVE : Member.Type.RESERVE;
        }

        public Builder withName(String name) {
            this.name = Assert.notNull(name, "name");
            return this;
        }

        public Builder withType(Member.Type type) {
            this.type = Assert.notNull(type, "type");
            return this;
        }

        public Builder withTransport(Transport transport) {
            Assert.notNull(transport, "transport");
            this.clientTransport = transport;
            this.serverTransport = transport;
            return this;
        }

        public Builder withClientTransport(Transport transport) {
            this.clientTransport = Assert.notNull(transport, "transport");
            return this;
        }

        public Builder withServerTransport(Transport transport) {
            this.serverTransport = Assert.notNull(transport, "transport");
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.serializer = Assert.notNull(serializer, "serializer");
            return this;
        }

        public Builder withStorage(Storage storage) {
            this.storage = Assert.notNull(storage, "storage");
            return this;
        }

        public Builder withStateMachine(Supplier<StateMachine> factory) {
            this.stateMachineFactory = Assert.notNull(factory, "factory");
            return this;
        }

        public Builder withElectionTimeout(Duration electionTimeout) {
            Assert.argNot(electionTimeout.isNegative() || electionTimeout.isZero(), "electionTimeout must be positive", new Object[0]);
            Assert.argNot(electionTimeout.toMillis() <= this.heartbeatInterval.toMillis(), "electionTimeout must be greater than heartbeatInterval", new Object[0]);
            this.electionTimeout = Assert.notNull(electionTimeout, "electionTimeout");
            return this;
        }

        public Builder withHeartbeatInterval(Duration heartbeatInterval) {
            Assert.argNot(heartbeatInterval.isNegative() || heartbeatInterval.isZero(), "sessionTimeout must be positive", new Object[0]);
            Assert.argNot(heartbeatInterval.toMillis() >= this.electionTimeout.toMillis(), "heartbeatInterval must be less than electionTimeout", new Object[0]);
            this.heartbeatInterval = Assert.notNull(heartbeatInterval, "heartbeatInterval");
            return this;
        }

        public Builder withSessionTimeout(Duration sessionTimeout) {
            Assert.argNot(sessionTimeout.isNegative() || sessionTimeout.isZero(), "sessionTimeout must be positive", new Object[0]);
            Assert.argNot(sessionTimeout.toMillis() <= this.electionTimeout.toMillis(), "sessionTimeout must be greater than electionTimeout", new Object[0]);
            this.sessionTimeout = Assert.notNull(sessionTimeout, "sessionTimeout");
            return this;
        }

        public Builder withGlobalSuspendTimeout(Duration globalSuspendTimeout) {
            Assert.notNull(globalSuspendTimeout, "globalSuspendTimeout");
            this.globalSuspendTimeout = Assert.argNot(globalSuspendTimeout, globalSuspendTimeout.isNegative() || globalSuspendTimeout.isZero(), "globalSuspendTimeout must be positive", new Object[0]);
            return this;
        }

        @Override
        public CopycatServer build() {
            if (this.stateMachineFactory == null) {
                throw new ConfigurationException("state machine not configured", new Object[0]);
            }
            if (this.serverTransport == null) {
                try {
                    this.serverTransport = (Transport)Class.forName("io.atomix.catalyst.transport.NettyTransport").newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new ConfigurationException("transport not configured", new Object[0]);
                }
            }
            if (this.clientTransport == null) {
                this.clientTransport = this.serverTransport;
            }
            if (this.serializer == null) {
                this.serializer = new Serializer(new PooledHeapAllocator());
            }
            this.serializer.resolve(new ClientRequestTypeResolver());
            this.serializer.resolve(new ClientResponseTypeResolver());
            this.serializer.resolve(new SessionTypeResolver());
            this.serializer.resolve(new ServerRequestTypeResolver());
            this.serializer.resolve(new ServerResponseTypeResolver());
            this.serializer.resolve(new EntryTypeResolver());
            this.serializer.resolve(new StateTypeResolver());
            if (this.storage == null) {
                this.storage = new Storage();
            }
            ConnectionManager connections = new ConnectionManager(this.serverTransport.client());
            SingleThreadContext threadContext = new SingleThreadContext("copycat-server-" + this.serverAddress, this.serializer);
            ServerContext context = new ServerContext(this.name, this.type, this.serverAddress, this.clientAddress, this.cluster, this.storage, this.serializer, this.stateMachineFactory, connections, threadContext);
            context.setElectionTimeout(this.electionTimeout).setHeartbeatInterval(this.heartbeatInterval).setSessionTimeout(this.sessionTimeout).setGlobalSuspendTimeout(this.globalSuspendTimeout);
            return new CopycatServer(this.name, this.clientTransport, this.serverTransport, context);
        }
    }

    public static enum State {
        INACTIVE,
        RESERVE,
        PASSIVE,
        FOLLOWER,
        CANDIDATE,
        LEADER;

    }
}

