/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Operation;
import io.atomix.copycat.error.CommandException;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachineContext;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.server.session.Sessions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.time.Clock;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class StateMachine
implements AutoCloseable {
    protected StateMachineExecutor executor;
    protected StateMachineContext context;
    protected Clock clock;
    protected Sessions sessions;

    protected StateMachine() {
    }

    public void init(StateMachineExecutor executor) {
        this.executor = Assert.notNull(executor, "executor");
        this.context = executor.context();
        this.clock = this.context.clock();
        this.sessions = this.context.sessions();
        if (this instanceof SessionListener) {
            executor.context().sessions().addListener((SessionListener)((Object)this));
        }
        this.configure(executor);
    }

    protected void configure(StateMachineExecutor executor) {
        this.registerOperations();
    }

    @Override
    public void close() {
    }

    private void registerOperations() {
        Class<?> type = this.getClass();
        for (Method method : type.getMethods()) {
            if (!this.isOperationMethod(method)) continue;
            this.registerMethod(method);
        }
    }

    private boolean isOperationMethod(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 1 && paramTypes[0] == Commit.class;
    }

    private void registerMethod(Method method) {
        Type genericType = method.getGenericParameterTypes()[0];
        Class<?> argumentType = this.resolveArgument(genericType);
        if (argumentType != null && Operation.class.isAssignableFrom(argumentType)) {
            this.registerMethod(argumentType, method);
        }
    }

    private Class<?> resolveArgument(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            return this.resolveClass(paramType.getActualTypeArguments()[0]);
        }
        if (type instanceof TypeVariable) {
            return this.resolveClass(type);
        }
        if (type instanceof Class) {
            TypeVariable<Class<T>>[] typeParams = ((Class)type).getTypeParameters();
            return this.resolveClass(typeParams[0]);
        }
        return null;
    }

    private Class<?> resolveClass(Type type) {
        Type[] bounds;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return this.resolveClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType && (bounds = ((WildcardType)type).getUpperBounds()).length > 0) {
            return (Class)bounds[0];
        }
        return null;
    }

    private void registerMethod(Class<?> type, Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE || returnType == Void.class) {
            this.registerVoidMethod(type, method);
        } else {
            this.registerValueMethod(type, method);
        }
    }

    private void registerVoidMethod(Class type, Method method) {
        this.executor.register(type, this.wrapVoidMethod(method));
    }

    private Consumer wrapVoidMethod(Method method) {
        return c -> {
            try {
                method.invoke((Object)this, c);
            }
            catch (InvocationTargetException e) {
                throw new CommandException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    private void registerValueMethod(Class type, Method method) {
        this.executor.register(type, this.wrapValueMethod(method));
    }

    private Function wrapValueMethod(Method method) {
        return c -> {
            try {
                return method.invoke((Object)this, c);
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError((Object)e);
            }
        };
    }
}

