/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.AbstractRequest;
import io.atomix.copycat.server.cluster.Member;
import java.util.Objects;

public abstract class ConfigurationRequest
extends AbstractRequest {
    protected Member member;

    public Member member() {
        return this.member;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        serializer.writeObject(this.member, buffer);
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.member = (Member)serializer.readObject(buffer);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.member);
    }

    public boolean equals(Object object) {
        if (this.getClass().isAssignableFrom(object.getClass())) {
            return ((ConfigurationRequest)object).member.equals(this.member);
        }
        return false;
    }

    public String toString() {
        return String.format("%s[member=%s]", this.getClass().getSimpleName(), this.member);
    }

    public static abstract class Builder<T extends Builder<T, U>, U extends ConfigurationRequest>
    extends AbstractRequest.Builder<T, U> {
        protected Builder(U request) {
            super(request);
        }

        public T withMember(Member member) {
            ((ConfigurationRequest)this.request).member = Assert.notNull(member, "member");
            return (T)this;
        }

        @Override
        public U build() {
            super.build();
            Assert.state(((ConfigurationRequest)this.request).member != null, "member cannot be null", new Object[0]);
            return (U)((ConfigurationRequest)this.request);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.request);
        }

        @Override
        public boolean equals(Object object) {
            return this.getClass().isAssignableFrom(object.getClass()) && ((Builder)object).request.equals(this.request);
        }

        @Override
        public String toString() {
            return String.format("%s[request=%s]", this.getClass().getCanonicalName(), this.request);
        }
    }
}

