/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.AbstractRequest;
import java.util.Objects;

public class InstallRequest
extends AbstractRequest {
    private long term;
    private int leader;
    protected long index;
    protected int offset;
    protected Buffer data;
    protected boolean complete;

    public static Builder builder() {
        return new Builder(new InstallRequest());
    }

    public static Builder builder(InstallRequest request) {
        return new Builder(request);
    }

    public long term() {
        return this.term;
    }

    public int leader() {
        return this.leader;
    }

    public long index() {
        return this.index;
    }

    public int offset() {
        return this.offset;
    }

    public Buffer data() {
        return this.data;
    }

    public boolean complete() {
        return this.complete;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeLong(this.term).writeInt(this.leader).writeLong(this.index).writeInt(this.offset).writeBoolean(this.complete);
        serializer.writeObject(this.data, buffer);
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.term = buffer.readLong();
        this.leader = buffer.readInt();
        this.index = buffer.readLong();
        this.offset = buffer.readInt();
        this.complete = buffer.readBoolean();
        this.data = ((Buffer)serializer.readObject(buffer)).flip();
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.term, this.leader, this.index, this.offset, this.complete, this.data);
    }

    public boolean equals(Object object) {
        if (object instanceof InstallRequest) {
            InstallRequest request = (InstallRequest)object;
            return request.term == this.term && request.leader == this.leader && request.index == this.index && request.offset == this.offset && request.complete == this.complete && request.data == this.data;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[term=%d, leader=%d, index=%d, offset=%d, data=%s, complete=%b]", this.getClass().getSimpleName(), this.term, this.leader, this.index, this.offset, this.data, this.complete);
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, InstallRequest> {
        protected Builder(InstallRequest request) {
            super(request);
        }

        public Builder withTerm(long term) {
            ((InstallRequest)this.request).term = Assert.arg(term, term > 0L, "term must be positive", new Object[0]);
            return this;
        }

        public Builder withLeader(int leader) {
            ((InstallRequest)this.request).leader = leader;
            return this;
        }

        public Builder withIndex(long index) {
            ((InstallRequest)this.request).index = Assert.argNot(index, index < 0L, "index must be positive", new Object[0]);
            return this;
        }

        public Builder withOffset(int offset) {
            ((InstallRequest)this.request).offset = Assert.argNot(offset, offset < 0, "offset must be positive", new Object[0]);
            return this;
        }

        public Builder withData(Buffer snapshot) {
            ((InstallRequest)this.request).data = Assert.notNull(snapshot, "data");
            return this;
        }

        public Builder withComplete(boolean complete) {
            ((InstallRequest)this.request).complete = complete;
            return this;
        }

        @Override
        public InstallRequest build() {
            super.build();
            Assert.stateNot(((InstallRequest)this.request).term <= 0L, "term must be positive", new Object[0]);
            Assert.argNot(((InstallRequest)this.request).index < 0L, "index must be positive", new Object[0]);
            Assert.notNull(((InstallRequest)this.request).data, "data");
            return (InstallRequest)this.request;
        }
    }
}

