/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.protocol.ConfigurationRequest;
import java.util.Objects;

public class ReconfigureRequest
extends ConfigurationRequest {
    private long index;

    public static Builder builder() {
        return new Builder(new ReconfigureRequest());
    }

    public static Builder builder(ReconfigureRequest request) {
        return new Builder(request);
    }

    public long index() {
        return this.index;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeLong(this.index);
        super.writeObject(buffer, serializer);
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.index = buffer.readLong();
        super.readObject(buffer, serializer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.index, this.member);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ReconfigureRequest) {
            ReconfigureRequest request = (ReconfigureRequest)object;
            return request.index == this.index && request.member.equals(this.member);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[index=%d, member=%s]", this.getClass().getSimpleName(), this.index, this.member);
    }

    public static class Builder
    extends ConfigurationRequest.Builder<Builder, ReconfigureRequest> {
        public Builder(ReconfigureRequest request) {
            super(request);
        }

        public Builder withIndex(long index) {
            ((ReconfigureRequest)this.request).index = Assert.argNot(index, index < 0L, "index must be positive", new Object[0]);
            return this;
        }
    }
}

