/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.error.InternalException;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.cluster.Member;
import io.atomix.copycat.server.protocol.AppendRequest;
import io.atomix.copycat.server.protocol.AppendResponse;
import io.atomix.copycat.server.protocol.ConfigureRequest;
import io.atomix.copycat.server.protocol.ConfigureResponse;
import io.atomix.copycat.server.protocol.InstallRequest;
import io.atomix.copycat.server.protocol.InstallResponse;
import io.atomix.copycat.server.state.AbstractAppender;
import io.atomix.copycat.server.state.LeaderState;
import io.atomix.copycat.server.state.MemberState;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

final class LeaderAppender
extends AbstractAppender {
    private final LeaderState leader;
    private final long leaderTime;
    private final long leaderIndex;
    private long heartbeatTime;
    private int heartbeatFailures;
    private CompletableFuture<Long> heartbeatFuture;
    private CompletableFuture<Long> nextHeartbeatFuture;
    private final Map<Long, CompletableFuture<Long>> appendFutures = new HashMap<Long, CompletableFuture<Long>>();

    LeaderAppender(LeaderState leader) {
        super(leader.context);
        this.leader = Assert.notNull(leader, "leader");
        this.leaderTime = System.currentTimeMillis();
        this.leaderIndex = this.context.getLog().nextIndex();
        this.heartbeatTime = this.leaderTime;
    }

    public long time() {
        return this.heartbeatTime;
    }

    public long index() {
        return this.leaderIndex;
    }

    private int quorumIndex() {
        return this.context.getClusterState().getQuorum() - 2;
    }

    public CompletableFuture<Long> appendEntries() {
        if (this.context.getClusterState().getRemoteMemberStates().isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.heartbeatFuture == null) {
            CompletableFuture<Long> newHeartbeatFuture = new CompletableFuture<Long>();
            this.heartbeatFuture = newHeartbeatFuture;
            this.heartbeatTime = System.currentTimeMillis();
            for (MemberState member : this.context.getClusterState().getRemoteMemberStates()) {
                this.appendEntries(member);
            }
            return newHeartbeatFuture;
        }
        if (this.nextHeartbeatFuture == null) {
            this.nextHeartbeatFuture = new CompletableFuture();
            return this.nextHeartbeatFuture;
        }
        return this.nextHeartbeatFuture;
    }

    public CompletableFuture<Long> appendEntries(long index) {
        if (index == 0L) {
            return this.appendEntries();
        }
        if (index <= this.context.getCommitIndex()) {
            return CompletableFuture.completedFuture(index);
        }
        if (this.context.getClusterState().getActiveMemberStates().isEmpty() && this.context.getClusterState().getPassiveMemberStates().isEmpty()) {
            long previousCommitIndex = this.context.getCommitIndex();
            this.context.setCommitIndex(index);
            this.context.setGlobalIndex(index);
            this.completeCommits(previousCommitIndex, index);
            return CompletableFuture.completedFuture(index);
        }
        if (this.context.getClusterState().getActiveMemberStates().isEmpty()) {
            long previousCommitIndex = this.context.getCommitIndex();
            this.context.setCommitIndex(index);
            this.completeCommits(previousCommitIndex, index);
            return CompletableFuture.completedFuture(index);
        }
        return this.appendFutures.computeIfAbsent(index, i -> {
            for (MemberState member : this.context.getClusterState().getActiveMemberStates()) {
                this.appendEntries(member);
            }
            return new CompletableFuture();
        });
    }

    @Override
    protected void appendEntries(MemberState member) {
        if (!this.open) {
            return;
        }
        if (member.getFailureCount() > 0) {
            if (this.canAppend(member)) {
                this.sendAppendRequest(member, this.buildAppendEmptyRequest(member));
            }
        } else if (member.getConfigTerm() < this.context.getTerm() || member.getConfigIndex() < this.context.getClusterState().getConfiguration().index()) {
            if (this.canConfigure(member)) {
                this.sendConfigureRequest(member, this.buildConfigureRequest(member));
            }
        } else if (member.getMember().type() == Member.Type.RESERVE || member.getMember().type() == Member.Type.PASSIVE) {
            if (this.canAppend(member)) {
                this.sendAppendRequest(member, this.buildAppendEmptyRequest(member));
            }
        } else if (member.getMember().type() == Member.Type.ACTIVE && this.context.getSnapshotStore().currentSnapshot() != null && this.context.getSnapshotStore().currentSnapshot().index() >= member.getNextIndex() && this.context.getSnapshotStore().currentSnapshot().index() > member.getSnapshotIndex()) {
            if (this.canInstall(member)) {
                this.sendInstallRequest(member, this.buildInstallRequest(member));
            }
        } else if (this.canAppend(member)) {
            this.sendAppendRequest(member, this.buildAppendRequest(member, this.context.getLog().lastIndex()));
        }
    }

    @Override
    protected boolean hasMoreEntries(MemberState member) {
        return member.getMember().type() != Member.Type.RESERVE && member.getMember().type() != Member.Type.PASSIVE && member.getNextIndex() <= this.context.getLog().lastIndex();
    }

    private long heartbeatTime() {
        int quorumIndex = this.quorumIndex();
        if (quorumIndex >= 0) {
            return this.context.getClusterState().getActiveMemberStates((m1, m2) -> Long.compare(m2.getHeartbeatTime(), m1.getHeartbeatTime())).get(quorumIndex).getHeartbeatTime();
        }
        return System.currentTimeMillis();
    }

    private void updateHeartbeatTime(MemberState member, Throwable error) {
        if (this.heartbeatFuture == null) {
            return;
        }
        if (error != null && member.getHeartbeatStartTime() == this.heartbeatTime) {
            int votingMemberSize = this.context.getClusterState().getActiveMemberStates().size() + (this.context.getCluster().member().type() == Member.Type.ACTIVE ? 1 : 0);
            int quorumSize = (int)Math.floor(votingMemberSize / 2) + 1;
            if (member.getMember().type() == Member.Type.ACTIVE && ++this.heartbeatFailures > votingMemberSize - quorumSize) {
                this.heartbeatFuture.completeExceptionally(new InternalException("Failed to reach consensus", new Object[0]));
                this.completeHeartbeat();
            }
        } else {
            member.setHeartbeatTime(System.currentTimeMillis());
            if (this.heartbeatTime <= this.heartbeatTime()) {
                this.heartbeatFuture.complete(null);
                this.completeHeartbeat();
            }
        }
    }

    private void completeHeartbeat() {
        this.heartbeatFailures = 0;
        this.heartbeatFuture = this.nextHeartbeatFuture;
        this.nextHeartbeatFuture = null;
        this.updateGlobalIndex();
        if (this.heartbeatFuture != null) {
            this.heartbeatTime = System.currentTimeMillis();
            for (MemberState member : this.context.getClusterState().getRemoteMemberStates()) {
                this.appendEntries(member);
            }
        }
    }

    private void updateGlobalIndex() {
        this.context.checkThread();
        long currentTime = System.currentTimeMillis();
        long globalMatchIndex = this.context.getClusterState().getRemoteMemberStates().stream().filter(m -> m.getMember().type() != Member.Type.RESERVE && (m.getMember().status() == Member.Status.AVAILABLE || currentTime - m.getMember().updated().toEpochMilli() < this.context.getGlobalSuspendTimeout().toMillis())).mapToLong(MemberState::getMatchIndex).min().orElse(this.context.getLog().lastIndex());
        this.context.setGlobalIndex(globalMatchIndex);
    }

    private void commitEntries() {
        this.context.checkThread();
        List<MemberState> members = this.context.getClusterState().getActiveMemberStates((m1, m2) -> Long.compare(m2.getMatchIndex() != 0L ? m2.getMatchIndex() : 0L, m1.getMatchIndex() != 0L ? m1.getMatchIndex() : 0L));
        if (members.isEmpty()) {
            long previousCommitIndex = this.context.getCommitIndex();
            long commitIndex = this.context.getLog().lastIndex();
            this.context.setCommitIndex(commitIndex);
            this.completeCommits(previousCommitIndex, commitIndex);
            return;
        }
        long commitIndex = members.get(this.quorumIndex()).getMatchIndex();
        long previousCommitIndex = this.context.getCommitIndex();
        if (commitIndex > 0L && commitIndex > previousCommitIndex && this.leaderIndex > 0L && commitIndex >= this.leaderIndex) {
            this.context.setCommitIndex(commitIndex);
            this.completeCommits(previousCommitIndex, commitIndex);
        }
    }

    private void completeCommits(long previousCommitIndex, long commitIndex) {
        for (long i = previousCommitIndex + 1L; i <= commitIndex; ++i) {
            CompletableFuture<Long> future = this.appendFutures.remove(i);
            if (future == null) continue;
            future.complete(i);
        }
    }

    @Override
    protected void sendAppendRequest(MemberState member, AppendRequest request) {
        member.setHeartbeatStartTime(this.heartbeatTime);
        super.sendAppendRequest(member, request);
    }

    @Override
    protected void handleAppendRequestFailure(MemberState member, AppendRequest request, Throwable error) {
        super.handleAppendRequestFailure(member, request, error);
        this.updateHeartbeatTime(member, error);
    }

    @Override
    protected void handleAppendResponseFailure(MemberState member, AppendRequest request, Throwable error) {
        this.updateHeartbeatTime(member, error);
        super.handleAppendResponseFailure(member, request, error);
    }

    @Override
    protected void handleAppendResponse(MemberState member, AppendRequest request, AppendResponse response) {
        this.updateHeartbeatTime(member, null);
        super.handleAppendResponse(member, request, response);
    }

    @Override
    protected void handleAppendResponseOk(MemberState member, AppendRequest request, AppendResponse response) {
        this.succeedAttempt(member);
        if (response.succeeded()) {
            this.updateMatchIndex(member, response);
            this.updateNextIndex(member);
            if (!request.entries().isEmpty()) {
                this.commitEntries();
            }
            if (this.hasMoreEntries(member)) {
                this.appendEntries(member);
            }
        } else if (response.term() > this.context.getTerm()) {
            this.context.setTerm(response.term()).setLeader(0);
            this.context.transition(CopycatServer.State.FOLLOWER);
        } else {
            this.resetMatchIndex(member, response);
            this.resetNextIndex(member);
            if (this.hasMoreEntries(member)) {
                this.appendEntries(member);
            }
        }
    }

    @Override
    protected void handleAppendResponseError(MemberState member, AppendRequest request, AppendResponse response) {
        if (response.term() > this.context.getTerm()) {
            this.LOGGER.debug("{} - Received higher term from {}", (Object)this.context.getClusterState().member().address(), (Object)member.getMember().serverAddress());
            this.context.setTerm(response.term()).setLeader(0);
            this.context.transition(CopycatServer.State.FOLLOWER);
        } else {
            super.handleAppendResponseError(member, request, response);
        }
    }

    @Override
    protected void succeedAttempt(MemberState member) {
        super.succeedAttempt(member);
        if (member.getMember().status() == Member.Status.UNAVAILABLE && !this.leader.configuring()) {
            member.getMember().update(Member.Status.AVAILABLE, Instant.now());
            this.leader.configure(this.context.getCluster().members());
        }
    }

    @Override
    protected void failAttempt(MemberState member, Throwable error) {
        super.failAttempt(member, error);
        if (System.currentTimeMillis() - Math.max(this.heartbeatTime(), this.leaderTime) > this.context.getElectionTimeout().toMillis() * 2L) {
            this.LOGGER.warn("{} - Suspected network partition. Stepping down", (Object)this.context.getCluster().member().address());
            this.context.setLeader(0);
            this.context.transition(CopycatServer.State.FOLLOWER);
        } else if (member.getFailureCount() >= 3 && member.getMember().status() == Member.Status.AVAILABLE && !this.leader.configuring()) {
            member.getMember().update(Member.Status.UNAVAILABLE, Instant.now());
            this.leader.configure(this.context.getCluster().members());
        }
    }

    @Override
    protected void handleConfigureResponse(MemberState member, ConfigureRequest request, ConfigureResponse response) {
        this.updateHeartbeatTime(member, null);
        super.handleConfigureResponse(member, request, response);
    }

    @Override
    protected void handleConfigureRequestFailure(MemberState member, ConfigureRequest request, Throwable error) {
        super.handleConfigureRequestFailure(member, request, error);
        this.updateHeartbeatTime(member, error);
    }

    @Override
    protected void handleConfigureResponseFailure(MemberState member, ConfigureRequest request, Throwable error) {
        this.updateHeartbeatTime(member, error);
        super.handleConfigureResponseFailure(member, request, error);
    }

    @Override
    protected void handleInstallResponse(MemberState member, InstallRequest request, InstallResponse response) {
        this.updateHeartbeatTime(member, null);
        super.handleInstallResponse(member, request, response);
    }

    @Override
    protected void handleInstallRequestFailure(MemberState member, InstallRequest request, Throwable error) {
        super.handleInstallRequestFailure(member, request, error);
        this.updateHeartbeatTime(member, error);
    }

    @Override
    protected void handleInstallResponseFailure(MemberState member, InstallRequest request, Throwable error) {
        this.updateHeartbeatTime(member, error);
        super.handleInstallResponseFailure(member, request, error);
    }
}

