/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.copycat.Command;
import io.atomix.copycat.server.StateMachineContext;
import io.atomix.copycat.server.state.ConnectionManager;
import io.atomix.copycat.server.state.ServerClock;
import io.atomix.copycat.server.state.ServerSessionContext;
import io.atomix.copycat.server.state.ServerSessionManager;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

class ServerStateMachineContext
implements StateMachineContext {
    private final ServerClock clock = new ServerClock();
    private final ConnectionManager connections;
    private final ServerSessionManager sessions;
    private long index;
    private boolean synchronous;
    private Command.ConsistencyLevel consistency;

    public ServerStateMachineContext(ConnectionManager connections, ServerSessionManager sessions) {
        this.connections = connections;
        this.sessions = sessions;
    }

    void update(long index, Instant instant, boolean synchronous, Command.ConsistencyLevel consistency) {
        this.index = index;
        this.clock.set(instant);
        this.synchronous = synchronous;
        this.consistency = consistency;
    }

    CompletableFuture<Void> commit() {
        long index = this.index;
        ArrayList<CompletableFuture<Void>> futures = null;
        for (ServerSessionContext session : this.sessions.sessions.values()) {
            CompletableFuture<Void> future = session.commit(index);
            if (future == null) continue;
            if (futures == null) {
                futures = new ArrayList<CompletableFuture<Void>>(8);
            }
            futures.add(future);
        }
        return futures != null ? CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])) : null;
    }

    boolean synchronous() {
        return this.synchronous;
    }

    Command.ConsistencyLevel consistency() {
        return this.consistency;
    }

    @Override
    public long index() {
        return this.index;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public ServerSessionManager sessions() {
        return this.sessions;
    }

    ConnectionManager connections() {
        return this.connections;
    }

    public String toString() {
        return String.format("%s[index=%d, time=%s]", this.getClass().getSimpleName(), this.index, this.clock);
    }
}

