/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage;

import io.atomix.catalyst.buffer.util.BitArray;
import io.atomix.catalyst.util.Assert;
import java.util.function.Predicate;

final class OffsetCleaner
implements Predicate<Long>,
AutoCloseable {
    private final BitArray bits;

    public OffsetCleaner() {
        this(BitArray.allocate(1024L));
    }

    OffsetCleaner(BitArray bits) {
        this.bits = Assert.notNull(bits, "bits");
    }

    @Override
    public boolean test(Long offset) {
        return this.isClean(offset);
    }

    public boolean clean(long offset) {
        Assert.argNot(offset < 0L, "offset must be positive", new Object[0]);
        if (this.bits.size() <= offset) {
            while (this.bits.size() <= offset) {
                this.bits.resize(this.bits.size() * 2L);
            }
        }
        return this.bits.set(offset);
    }

    public boolean isClean(long offset) {
        return offset == -1L || this.bits.size() > offset && this.bits.get(offset);
    }

    public long count() {
        return this.bits.count();
    }

    BitArray bits() {
        return this.bits;
    }

    @Override
    public void close() {
        this.bits.close();
    }
}

