/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.FileBuffer;
import io.atomix.catalyst.buffer.HeapBuffer;
import io.atomix.catalyst.buffer.MappedBuffer;
import io.atomix.catalyst.util.Assert;

public final class SegmentDescriptor
implements AutoCloseable {
    public static final int BYTES = 64;
    private Buffer buffer;
    private final long id;
    private final long index;
    private final long version;
    private long updated;
    private final long maxSegmentSize;
    private final int maxEntries;
    private boolean locked;

    public static Builder builder() {
        return new Builder(HeapBuffer.allocate(64L));
    }

    public static Builder builder(Buffer buffer) {
        return new Builder(buffer);
    }

    public SegmentDescriptor(Buffer buffer) {
        this.buffer = Assert.notNull(buffer, "buffer");
        this.id = buffer.readLong();
        this.version = buffer.readLong();
        this.index = buffer.readLong();
        this.maxSegmentSize = buffer.readUnsignedInt();
        this.maxEntries = buffer.readInt();
        this.updated = buffer.readLong();
        this.locked = buffer.readBoolean();
        buffer.skip(23L);
    }

    public long id() {
        return this.id;
    }

    public long version() {
        return this.version;
    }

    public long index() {
        return this.index;
    }

    public long maxSegmentSize() {
        return this.maxSegmentSize;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long updated() {
        return this.updated;
    }

    public void update(long timestamp) {
        if (!this.locked) {
            this.buffer.writeLong(35L, timestamp);
            this.updated = timestamp;
        }
    }

    public boolean locked() {
        return this.locked;
    }

    public void lock() {
        this.buffer.writeBoolean(43L, true).flush();
        this.locked = true;
    }

    SegmentDescriptor copyTo(Buffer buffer) {
        this.buffer = (Buffer)buffer.writeLong(this.id).writeLong(this.version).writeLong(this.index).writeUnsignedInt(this.maxSegmentSize).writeInt(this.maxEntries).writeLong(this.updated).writeBoolean(this.locked).skip(23L).flush();
        return this;
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    public void delete() {
        if (this.buffer instanceof FileBuffer) {
            ((FileBuffer)this.buffer).delete();
        } else if (this.buffer instanceof MappedBuffer) {
            ((MappedBuffer)this.buffer).delete();
        }
    }

    public static class Builder {
        private final Buffer buffer;

        private Builder(Buffer buffer) {
            this.buffer = Assert.notNull(buffer, "buffer");
        }

        public Builder withId(long id) {
            this.buffer.writeLong(0L, id);
            return this;
        }

        public Builder withVersion(long version) {
            this.buffer.writeLong(8L, version);
            return this;
        }

        public Builder withIndex(long index) {
            this.buffer.writeLong(16L, index);
            return this;
        }

        public Builder withMaxSegmentSize(long maxSegmentSize) {
            this.buffer.writeUnsignedInt(24L, maxSegmentSize);
            return this;
        }

        public Builder withMaxEntries(int maxEntries) {
            this.buffer.writeInt(28L, maxEntries);
            return this;
        }

        public SegmentDescriptor build() {
            return new SegmentDescriptor(this.buffer.writeLong(32L, 0L).rewind());
        }
    }
}

