/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.compaction;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.Segment;
import io.atomix.copycat.server.storage.SegmentManager;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.server.storage.compaction.CompactionManager;
import io.atomix.copycat.server.storage.compaction.CompactionTask;
import io.atomix.copycat.server.storage.compaction.Compactor;
import io.atomix.copycat.server.storage.compaction.MajorCompactionTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class MajorCompactionManager
implements CompactionManager {
    private final Compactor compactor;

    MajorCompactionManager(Compactor compactor) {
        this.compactor = Assert.notNull(compactor, "compactor");
    }

    public List<CompactionTask> buildTasks(Storage storage, SegmentManager segments) {
        List<List<Segment>> groups = this.getCompactableGroups(storage, segments);
        return !groups.isEmpty() ? Collections.singletonList(new MajorCompactionTask(segments, groups, this.compactor.snapshotIndex(), this.compactor.majorIndex(), this.compactor.getDefaultCompactionMode())) : Collections.emptyList();
    }

    public List<List<Segment>> getCompactableGroups(Storage storage, SegmentManager manager) {
        ArrayList<List<Segment>> clean = new ArrayList<List<Segment>>();
        ArrayList<Segment> segments = null;
        Segment previousSegment = null;
        for (Segment segment : this.getCompactableSegments(manager)) {
            if (segments == null) {
                segments = new ArrayList<Segment>();
                segments.add(segment);
            } else if (previousSegment != null && previousSegment.descriptor().version() != segment.descriptor().version()) {
                clean.add(segments);
                segments = new ArrayList();
                segments.add(segment);
            } else if (segments.stream().mapToLong(Segment::size).sum() + segment.size() <= (long)storage.maxSegmentSize() && segments.stream().mapToLong(Segment::count).sum() + (long)segment.count() <= (long)storage.maxEntriesPerSegment()) {
                segments.add(segment);
            } else {
                clean.add(segments);
                segments = new ArrayList();
                segments.add(segment);
            }
            previousSegment = segment;
        }
        if (segments != null) {
            clean.add(segments);
        }
        return clean;
    }

    private List<Segment> getCompactableSegments(SegmentManager manager) {
        ArrayList<Segment> segments = new ArrayList<Segment>(manager.segments().size());
        Iterator<Segment> iterator = manager.segments().iterator();
        Segment segment = iterator.next();
        while (iterator.hasNext()) {
            Segment nextSegment = iterator.next();
            if (!segment.isCompacted() && (!segment.isFull() || segment.lastIndex() >= this.compactor.minorIndex() || nextSegment.firstIndex() > manager.commitIndex() || nextSegment.isEmpty())) break;
            segments.add(segment);
            segment = nextSegment;
        }
        return segments;
    }
}

