/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.compaction;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.Segment;
import io.atomix.copycat.server.storage.SegmentDescriptor;
import io.atomix.copycat.server.storage.SegmentManager;
import io.atomix.copycat.server.storage.compaction.Compaction;
import io.atomix.copycat.server.storage.compaction.CompactionTask;
import io.atomix.copycat.server.storage.entry.Entry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MajorCompactionTask
implements CompactionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MajorCompactionTask.class);
    private final SegmentManager manager;
    private final List<List<Segment>> groups;
    private List<List<Predicate<Long>>> cleaners;
    private final long snapshotIndex;
    private final long compactIndex;
    private final Compaction.Mode defaultCompactionMode;

    MajorCompactionTask(SegmentManager manager, List<List<Segment>> groups, long snapshotIndex, long compactIndex, Compaction.Mode defaultCompactionMode) {
        this.manager = Assert.notNull(manager, "manager");
        this.groups = Assert.notNull(groups, "segments");
        this.snapshotIndex = snapshotIndex;
        this.compactIndex = compactIndex;
        this.defaultCompactionMode = Assert.notNull(defaultCompactionMode, "defaultCompactionMode");
    }

    @Override
    public void run() {
        this.storeCleaners();
        this.compactGroups();
    }

    private void storeCleaners() {
        this.cleaners = new ArrayList<List<Predicate<Long>>>(this.groups.size());
        for (List<Segment> group : this.groups) {
            ArrayList<Predicate<Long>> groupCleaners = new ArrayList<Predicate<Long>>(group.size());
            for (Segment segment : group) {
                groupCleaners.add(segment.cleanPredicate());
            }
            this.cleaners.add(groupCleaners);
        }
    }

    private void compactGroups() {
        for (int i = 0; i < this.groups.size(); ++i) {
            List<Segment> group = this.groups.get(i);
            List<Predicate<Long>> groupCleaners = this.cleaners.get(i);
            Segment segment = this.compactGroup(group, groupCleaners);
            this.updateCleaned(group, groupCleaners, segment);
            this.deleteGroup(group);
        }
    }

    private Segment compactGroup(List<Segment> segments, List<Predicate<Long>> cleaners) {
        Segment firstSegment = segments.iterator().next();
        Segment compactSegment = this.manager.createSegment(SegmentDescriptor.builder().withId(firstSegment.descriptor().id()).withVersion(firstSegment.descriptor().version() + 1L).withIndex(firstSegment.descriptor().index()).withMaxSegmentSize(segments.stream().mapToLong(s -> s.descriptor().maxSegmentSize()).max().getAsLong()).withMaxEntries(segments.stream().mapToInt(s -> s.descriptor().maxEntries()).max().getAsInt()).build());
        this.compactGroup(segments, cleaners, compactSegment);
        this.manager.replaceSegments(segments, compactSegment);
        return compactSegment;
    }

    private void compactGroup(List<Segment> segments, List<Predicate<Long>> cleaners, Segment compactSegment) {
        for (int i = 0; i < segments.size(); ++i) {
            this.compactSegment(segments.get(i), cleaners.get(i), compactSegment);
        }
    }

    private void compactSegment(Segment segment, Predicate<Long> cleaner, Segment compactSegment) {
        for (long i = segment.firstIndex(); i <= segment.lastIndex(); ++i) {
            this.checkEntry(i, segment, cleaner, compactSegment);
        }
    }

    private void checkEntry(long index, Segment segment, Predicate<Long> cleaner, Segment compactSegment) {
        try (Object entry = segment.get(index);){
            if (entry != null) {
                this.checkEntry(index, (Entry)entry, segment, cleaner, compactSegment);
            } else {
                compactSegment.skip(1L);
            }
        }
    }

    private void checkEntry(long index, Entry entry, Segment segment, Predicate<Long> cleaner, Segment compactSegment) {
        Compaction.Mode mode = entry.getCompactionMode();
        if (mode == Compaction.Mode.DEFAULT) {
            mode = this.defaultCompactionMode;
        }
        switch (mode) {
            case SNAPSHOT: {
                if (index <= this.snapshotIndex && this.isClean(index, segment, cleaner)) {
                    this.compactEntry(index, segment, compactSegment);
                    break;
                }
                this.transferEntry(entry, compactSegment);
                break;
            }
            case QUORUM: {
                if (this.isClean(index, segment, cleaner)) {
                    this.compactEntry(index, segment, compactSegment);
                    break;
                }
                this.transferEntry(entry, compactSegment);
                break;
            }
            case FULL: 
            case SEQUENTIAL: {
                if (index <= this.compactIndex && this.isClean(index, segment, cleaner)) {
                    this.compactEntry(index, segment, compactSegment);
                    break;
                }
                this.transferEntry(entry, compactSegment);
                break;
            }
            case UNKNOWN: {
                if (index <= this.snapshotIndex && index <= this.compactIndex && this.isClean(index, segment, cleaner)) {
                    this.compactEntry(index, segment, compactSegment);
                    break;
                }
                this.transferEntry(entry, compactSegment);
                break;
            }
        }
    }

    private void compactEntry(long index, Segment segment, Segment compactSegment) {
        compactSegment.skip(1L);
        LOGGER.debug("Compacted entry {} from segment {}", (Object)index, (Object)segment.descriptor().id());
    }

    private void transferEntry(Entry entry, Segment compactSegment) {
        compactSegment.append(entry);
    }

    private boolean isClean(long index, Segment segment, Predicate<Long> cleaner) {
        long offset = segment.offset(index);
        return offset == -1L || cleaner.test(offset);
    }

    private void updateCleaned(List<Segment> segments, List<Predicate<Long>> cleaners, Segment compactSegment) {
        for (int i = 0; i < segments.size(); ++i) {
            this.updateCleanedOffsets(segments.get(i), cleaners.get(i), compactSegment);
        }
    }

    private void updateCleanedOffsets(Segment segment, Predicate<Long> cleaner, Segment compactSegment) {
        for (long i = segment.firstIndex(); i <= segment.lastIndex(); ++i) {
            long offset = segment.offset(i);
            if (offset == -1L || !cleaner.test(offset)) continue;
            compactSegment.clean(i);
        }
    }

    private void deleteGroup(List<Segment> group) {
        for (Segment oldSegment : group) {
            oldSegment.close();
            oldSegment.delete();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

