/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.compaction;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.Segment;
import io.atomix.copycat.server.storage.SegmentDescriptor;
import io.atomix.copycat.server.storage.SegmentManager;
import io.atomix.copycat.server.storage.compaction.Compaction;
import io.atomix.copycat.server.storage.compaction.CompactionTask;
import io.atomix.copycat.server.storage.entry.Entry;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MinorCompactionTask
implements CompactionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinorCompactionTask.class);
    private final SegmentManager manager;
    private final Segment segment;
    private final long snapshotIndex;
    private final long compactIndex;
    private final Compaction.Mode defaultCompactionMode;

    MinorCompactionTask(SegmentManager manager, Segment segment, long snapshotIndex, long compactIndex, Compaction.Mode defaultCompactionMode) {
        this.manager = Assert.notNull(manager, "manager");
        this.segment = Assert.notNull(segment, "segment");
        this.snapshotIndex = snapshotIndex;
        this.compactIndex = compactIndex;
        this.defaultCompactionMode = Assert.notNull(defaultCompactionMode, "defaultCompactionMode");
    }

    @Override
    public void run() {
        this.compactSegments();
    }

    private void compactSegments() {
        Segment compactSegment = this.manager.createSegment(SegmentDescriptor.builder().withId(this.segment.descriptor().id()).withVersion(this.segment.descriptor().version() + 1L).withIndex(this.segment.descriptor().index()).withMaxSegmentSize(this.segment.descriptor().maxSegmentSize()).withMaxEntries(this.segment.descriptor().maxEntries()).build());
        this.compactEntries(this.segment, compactSegment);
        this.manager.replaceSegments(Collections.singletonList(this.segment), compactSegment);
        this.segment.close();
        this.segment.delete();
    }

    private void compactEntries(Segment segment, Segment compactSegment) {
        for (long i = segment.firstIndex(); i <= segment.lastIndex(); ++i) {
            this.checkEntry(i, segment, compactSegment);
        }
    }

    private void checkEntry(long index, Segment segment, Segment cleanSegment) {
        try (Object entry = segment.get(index);){
            if (entry != null) {
                this.checkEntry(index, (Entry)entry, segment, cleanSegment);
            } else {
                cleanSegment.skip(1L);
            }
        }
    }

    private void checkEntry(long index, Entry entry, Segment segment, Segment compactSegment) {
        Compaction.Mode mode = entry.getCompactionMode();
        if (mode == Compaction.Mode.DEFAULT) {
            mode = this.defaultCompactionMode;
        }
        switch (mode) {
            case SNAPSHOT: {
                if (index <= this.snapshotIndex && segment.isClean(index)) {
                    this.compactEntry(index, segment, compactSegment);
                    break;
                }
                this.transferEntry(index, entry, compactSegment);
                break;
            }
            case QUORUM: {
                if (segment.isClean(index)) {
                    this.compactEntry(index, segment, compactSegment);
                    break;
                }
                this.transferEntry(index, entry, compactSegment);
                break;
            }
            case FULL: {
                if (index <= this.compactIndex && segment.isClean(index)) {
                    this.compactEntry(index, segment, compactSegment);
                    break;
                }
                this.transferEntry(index, entry, compactSegment);
                break;
            }
            case SEQUENTIAL: 
            case UNKNOWN: {
                this.transferEntry(index, entry, compactSegment);
                break;
            }
        }
    }

    private void compactEntry(long index, Segment segment, Segment compactSegment) {
        compactSegment.skip(1L);
        LOGGER.debug("Compacted entry {} from segment {}", (Object)index, (Object)segment.descriptor().id());
    }

    private void transferEntry(long index, Entry entry, Segment compactSegment) {
        compactSegment.append(entry);
        if (this.segment.isClean(index)) {
            compactSegment.clean(index);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

