/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.entry;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.ReferenceManager;
import io.atomix.copycat.Command;
import io.atomix.copycat.Operation;
import io.atomix.copycat.server.storage.compaction.Compaction;
import io.atomix.copycat.server.storage.entry.Entry;
import io.atomix.copycat.server.storage.entry.OperationEntry;

public class CommandEntry
extends OperationEntry<CommandEntry> {
    private Command command;

    public CommandEntry() {
    }

    public CommandEntry(ReferenceManager<Entry<?>> referenceManager) {
        super(referenceManager);
    }

    @Override
    public Compaction.Mode getCompactionMode() {
        return Compaction.Mode.valueOf(this.command.compaction().name());
    }

    @Override
    public Operation getOperation() {
        return this.command;
    }

    public Command getCommand() {
        return this.command;
    }

    public CommandEntry setCommand(Command command) {
        this.command = Assert.notNull(command, "command");
        return this;
    }

    @Override
    public void writeObject(BufferOutput buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        serializer.writeObject(this.command, buffer);
    }

    @Override
    public void readObject(BufferInput buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.command = (Command)serializer.readObject(buffer);
    }

    @Override
    public String toString() {
        return String.format("%s[index=%d, term=%d, session=%d, sequence=%d, timestamp=%d, command=%s]", this.getClass().getSimpleName(), this.getIndex(), this.getTerm(), this.getSession(), this.getSequence(), this.getTimestamp(), this.command);
    }
}

