/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.entry;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.ReferenceCounted;
import io.atomix.catalyst.util.ReferenceManager;
import io.atomix.copycat.server.storage.compaction.Compaction;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Entry<T extends Entry<T>>
implements ReferenceCounted<Entry>,
CatalystSerializable {
    private final ReferenceManager<Entry<?>> referenceManager;
    private final AtomicInteger references = new AtomicInteger();
    private long index;
    private long term;
    private int size = -1;

    protected Entry() {
        this.referenceManager = null;
    }

    protected Entry(ReferenceManager<Entry<?>> referenceManager) {
        this.referenceManager = referenceManager;
    }

    protected T reset() {
        this.index = 0L;
        this.size = -1;
        return (T)this;
    }

    public long getIndex() {
        return this.index;
    }

    public T setIndex(long index) {
        this.index = index;
        return (T)this;
    }

    public Compaction.Mode getCompactionMode() {
        return Compaction.Mode.QUORUM;
    }

    public long getTerm() {
        return this.term;
    }

    public T setTerm(long term) {
        this.term = term;
        return (T)this;
    }

    public int size() {
        Assert.stateNot(this.size == -1, "cannot determine size for non-persisted entry", new Object[0]);
        return this.size;
    }

    public T setSize(int size) {
        this.size = size;
        return (T)this;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
    }

    @Override
    public Entry acquire() {
        this.references.incrementAndGet();
        return this;
    }

    @Override
    public boolean release() {
        int refs = this.references.decrementAndGet();
        if (refs == 0) {
            if (this.referenceManager != null) {
                this.referenceManager.release(this);
            }
            return true;
        }
        if (refs < 0) {
            this.references.set(0);
            throw new IllegalStateException("cannot dereference non-referenced object");
        }
        return false;
    }

    @Override
    public int references() {
        return this.references.get();
    }

    @Override
    public void close() {
        this.release();
    }
}

