/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.entry;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.ReferenceManager;
import io.atomix.copycat.server.storage.entry.Entry;
import io.atomix.copycat.server.storage.entry.SessionEntry;

public class KeepAliveEntry
extends SessionEntry<KeepAliveEntry> {
    private long commandSequence;
    private long eventIndex;

    public KeepAliveEntry() {
    }

    public KeepAliveEntry(ReferenceManager<Entry<?>> referenceManager) {
        super(referenceManager);
    }

    public long getCommandSequence() {
        return this.commandSequence;
    }

    public KeepAliveEntry setCommandSequence(long commandSequence) {
        this.commandSequence = commandSequence;
        return this;
    }

    public long getEventIndex() {
        return this.eventIndex;
    }

    public KeepAliveEntry setEventIndex(long eventIndex) {
        this.eventIndex = eventIndex;
        return this;
    }

    @Override
    public void readObject(BufferInput buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.commandSequence = buffer.readLong();
        this.eventIndex = buffer.readLong();
    }

    @Override
    public void writeObject(BufferOutput buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeLong(this.commandSequence);
        buffer.writeLong(this.eventIndex);
    }

    @Override
    public String toString() {
        return String.format("%s[index=%d, term=%d, session=%d, commandSequence=%d, eventIndex=%d, timestamp=%d]", this.getClass().getSimpleName(), this.getIndex(), this.getTerm(), this.getSession(), this.getCommandSequence(), this.getEventIndex(), this.getTimestamp());
    }
}

