/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.entry;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.ReferenceManager;
import io.atomix.copycat.Operation;
import io.atomix.copycat.Query;
import io.atomix.copycat.server.storage.entry.Entry;
import io.atomix.copycat.server.storage.entry.OperationEntry;

public class QueryEntry
extends OperationEntry<QueryEntry> {
    private Query query;

    public QueryEntry() {
    }

    public QueryEntry(ReferenceManager<Entry<?>> referenceManager) {
        super(referenceManager);
    }

    @Override
    public Operation getOperation() {
        return this.query;
    }

    public Query getQuery() {
        return this.query;
    }

    public QueryEntry setQuery(Query query) {
        this.query = Assert.notNull(query, "query");
        return this;
    }

    @Override
    public void writeObject(BufferOutput buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        serializer.writeObject(this.query, buffer);
    }

    @Override
    public void readObject(BufferInput buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.query = (Query)serializer.readObject(buffer);
    }

    @Override
    public String toString() {
        return String.format("%s[index=%d, term=%d, session=%d, sequence=%d, timestamp=%d, query=%s]", this.getClass().getSimpleName(), this.getIndex(), this.getTerm(), this.getSession(), this.getSequence(), this.getTimestamp(), this.query);
    }
}

