/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.entry;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.ReferenceManager;
import io.atomix.copycat.server.storage.entry.Entry;

public abstract class TimestampedEntry<T extends TimestampedEntry<T>>
extends Entry<T> {
    private long timestamp;

    protected TimestampedEntry() {
    }

    protected TimestampedEntry(ReferenceManager<Entry<?>> referenceManager) {
        super(referenceManager);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public T setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return (T)this;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeLong(this.timestamp);
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.timestamp = buffer.readLong();
    }

    public String toString() {
        return String.format("%s[index=%d, term=%d, timestamp=%d]", this.getClass().getSimpleName(), this.getIndex(), this.getTerm(), this.timestamp);
    }
}

