/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.snapshot;

import io.atomix.catalyst.buffer.FileBuffer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.snapshot.Snapshot;
import io.atomix.copycat.server.storage.snapshot.SnapshotDescriptor;
import io.atomix.copycat.server.storage.snapshot.SnapshotFile;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotStore;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

final class FileSnapshot
extends Snapshot {
    private final SnapshotFile file;
    private final SnapshotStore store;

    FileSnapshot(SnapshotFile file, SnapshotStore store) {
        super(store);
        this.file = Assert.notNull(file, "file");
        this.store = Assert.notNull(store, "store");
    }

    @Override
    public long index() {
        return this.file.index();
    }

    @Override
    public long timestamp() {
        return this.file.timestamp();
    }

    @Override
    public synchronized SnapshotWriter writer() {
        this.checkWriter();
        SnapshotDescriptor descriptor = SnapshotDescriptor.builder().withIndex(this.file.index()).withTimestamp(this.file.timestamp()).build();
        FileBuffer buffer = FileBuffer.allocate(this.file.file(), 64L, this.store.storage.maxSnapshotSize());
        descriptor.copyTo(buffer);
        int length = buffer.position(64L).readInt();
        return this.openWriter(new SnapshotWriter(buffer.skip(length).mark(), this, this.store.serializer()), descriptor);
    }

    @Override
    protected void closeWriter(SnapshotWriter writer) {
        int length = (int)(writer.buffer.position() - 68L);
        writer.buffer.writeInt(64L, length).flush();
        super.closeWriter(writer);
    }

    @Override
    public synchronized SnapshotReader reader() {
        Assert.state(this.file.file().exists(), "missing snapshot file: %s", this.file.file());
        FileBuffer buffer = FileBuffer.allocate(this.file.file(), 64L, this.store.storage.maxSnapshotSize());
        SnapshotDescriptor descriptor = new SnapshotDescriptor(buffer);
        int length = buffer.position(64L).readInt();
        return this.openReader(new SnapshotReader(buffer.mark().limit(68 + length), this, this.store.serializer()), descriptor);
    }

    @Override
    public Snapshot complete() {
        FileBuffer buffer = FileBuffer.allocate(this.file.file(), 64L, this.store.storage.maxSnapshotSize());
        SnapshotDescriptor descriptor = new SnapshotDescriptor(buffer);
        Assert.stateNot(descriptor.locked(), "cannot complete locked snapshot descriptor", new Object[0]);
        descriptor.lock();
        descriptor.close();
        return super.complete();
    }

    @Override
    public void delete() {
        Path path = this.file.file().toPath();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.delete(this.file.file().toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return String.format("%s[index=%d]", this.getClass().getSimpleName(), this.index());
    }
}

