/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.system;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.FileBuffer;
import io.atomix.catalyst.buffer.HeapBuffer;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.server.storage.StorageLevel;
import io.atomix.copycat.server.storage.system.Configuration;
import java.io.File;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStore
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaStore.class);
    private final Storage storage;
    private final Serializer serializer;
    private final Buffer buffer;

    public MetaStore(String name, Storage storage, Serializer serializer) {
        this.storage = Assert.notNull(storage, "storage");
        this.serializer = Assert.notNull(serializer, "serializer");
        if (storage.level() == StorageLevel.MEMORY) {
            this.buffer = HeapBuffer.allocate(12L);
        } else {
            storage.directory().mkdirs();
            File file = new File(storage.directory(), String.format("%s.meta", name));
            this.buffer = FileBuffer.allocate(file, 12L);
        }
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public synchronized MetaStore storeTerm(long term) {
        LOGGER.debug("Store term {}", (Object)term);
        this.buffer.writeLong(0L, term).flush();
        return this;
    }

    public synchronized long loadTerm() {
        return this.buffer.readLong(0L);
    }

    public synchronized MetaStore storeVote(int vote) {
        LOGGER.debug("Store vote {}", (Object)vote);
        this.buffer.writeInt(8L, vote).flush();
        return this;
    }

    public synchronized int loadVote() {
        return this.buffer.readInt(8L);
    }

    public synchronized MetaStore storeConfiguration(Configuration configuration) {
        LOGGER.debug("Store configuration {}", (Object)configuration);
        this.serializer.writeObject(configuration.members(), this.buffer.position(12L).writeByte(1).writeLong(configuration.index()).writeLong(configuration.time()));
        this.buffer.flush();
        return this;
    }

    public synchronized Configuration loadConfiguration() {
        if (this.buffer.position(12L).readByte() == 1) {
            return new Configuration(this.buffer.readLong(), this.buffer.readLong(), (Collection)this.serializer.readObject(this.buffer));
        }
        return null;
    }

    @Override
    public synchronized void close() {
        this.buffer.close();
    }

    public String toString() {
        if (this.buffer instanceof FileBuffer) {
            return String.format("%s[%s]", this.getClass().getSimpleName(), ((FileBuffer)this.buffer).file());
        }
        return this.getClass().getSimpleName();
    }
}

