/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager;

import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.ConfigurationException;
import io.atomix.catalyst.util.concurrent.Futures;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.client.ConnectionStrategies;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.copycat.client.RecoveryStrategies;
import io.atomix.copycat.client.RetryStrategies;
import io.atomix.copycat.client.ServerSelectionStrategies;
import io.atomix.manager.ResourceManager;
import io.atomix.manager.ResourceManagerTypeResolver;
import io.atomix.manager.state.GetResourceKeys;
import io.atomix.manager.state.ResourceExists;
import io.atomix.resource.Instance;
import io.atomix.resource.InstanceClient;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceRegistry;
import io.atomix.resource.ResourceType;
import io.atomix.resource.ResourceTypeResolver;
import io.atomix.resource.ServiceLoaderResourceResolver;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceClient
implements ResourceManager<ResourceClient> {
    final CopycatClient client;
    private final ResourceRegistry registry;
    private final Map<Class<? extends Resource<?>>, ResourceType> types = new ConcurrentHashMap();
    private final Map<String, Resource<?>> instances = new HashMap();
    private final Map<String, CompletableFuture> futures = new HashMap<String, CompletableFuture>();

    public static Builder builder(Address ... members) {
        return new Builder(Arrays.asList((Object[])Assert.notNull(members, "members")));
    }

    public static Builder builder(Collection<Address> members) {
        return new Builder(members);
    }

    public ResourceClient(CopycatClient client, ResourceRegistry registry) {
        this.client = Assert.notNull(client, "client");
        this.registry = Assert.notNull(registry, "registry");
    }

    public CopycatClient client() {
        return this.client;
    }

    @Override
    public ThreadContext context() {
        return this.client.context();
    }

    @Override
    public Serializer serializer() {
        return this.client.serializer();
    }

    @Override
    public final ResourceType type(Class<? extends Resource<?>> type) {
        return this.types.computeIfAbsent(type, t -> {
            ResourceType resourceType = new ResourceType(type);
            if (this.registry.lookup(resourceType.id()) == null) {
                throw new IllegalArgumentException("unregistered resource type");
            }
            return resourceType;
        });
    }

    @Override
    public CompletableFuture<Boolean> exists(String key) {
        return this.client.submit(new ResourceExists(key));
    }

    @Override
    public CompletableFuture<Set<String>> keys() {
        return this.client.submit(new GetResourceKeys());
    }

    @Override
    public <T extends Resource> CompletableFuture<Set<String>> keys(Class<? super T> type) {
        return this.keys(this.type(type));
    }

    @Override
    public CompletableFuture<Set<String>> keys(ResourceType type) {
        return this.client.submit(new GetResourceKeys(Assert.notNull(type, "type").id()));
    }

    @Override
    public <T extends Resource> CompletableFuture<T> get(String key, Class<? super T> type) {
        return this.get(key, this.type(type), null, null);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> get(String key, Class<? super T> type, Resource.Config config) {
        return this.get(key, this.type(type), config, null);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> get(String key, Class<? super T> type, Resource.Options options) {
        return this.get(key, this.type(type), null, options);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> get(String key, Class<? super T> type, Resource.Config config, Resource.Options options) {
        return this.get(key, this.type(type), config, options);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> get(String key, ResourceType type) {
        return this.get(key, type, null, null);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> get(String key, ResourceType type, Resource.Config config) {
        return this.get(key, type, config, null);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> get(String key, ResourceType type, Resource.Options options) {
        return this.get(key, type, null, options);
    }

    @Override
    public synchronized <T extends Resource> CompletableFuture<T> get(String key, ResourceType type, Resource.Config config, Resource.Options options) {
        Assert.notNull(key, "key");
        Assert.notNull(type, "type");
        Resource<Object> check = this.instances.get(key);
        if (check == null) {
            if (options == null) {
                options = new Resource.Options();
            }
            Instance instance = new Instance(key, type, Instance.Method.GET, this::close);
            InstanceClient client = new InstanceClient(instance, this.client);
            check = type.factory().create(client, options);
            this.instances.put(key, check);
        }
        if (check.getClass() != type.resource()) {
            return Futures.exceptionalFuture(new IllegalArgumentException("inconsistent resource type: " + type));
        }
        Resource<?> resource = check;
        CompletionStage<Object> future = this.futures.get(key);
        if (future == null) {
            future = resource.open();
            if (config != null) {
                future = future.thenCompose(v -> resource.configure(config));
            }
            this.futures.put(key, (CompletableFuture)future);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Instance instance) {
        if (instance.method() == Instance.Method.GET) {
            ResourceClient resourceClient = this;
            synchronized (resourceClient) {
                this.instances.remove(instance.key());
                this.futures.remove(instance.key());
            }
        }
    }

    @Override
    public CompletableFuture<ResourceClient> open() {
        return this.client.open().thenApply(v -> this);
    }

    @Override
    public boolean isOpen() {
        return this.client.isOpen();
    }

    @Override
    public CompletableFuture<Void> close() {
        CompletableFuture[] futures = new CompletableFuture[this.instances.size()];
        int i = 0;
        for (Resource<?> instance : this.instances.values()) {
            futures[i++] = instance.close();
        }
        return CompletableFuture.allOf(futures).thenCompose(v -> this.client.close());
    }

    @Override
    public boolean isClosed() {
        return this.client.isClosed();
    }

    public String toString() {
        return String.format("%s[session=%s]", this.getClass().getSimpleName(), this.client.session());
    }

    public static class Builder
    implements io.atomix.catalyst.util.Builder<ResourceClient> {
        private CopycatClient.Builder clientBuilder;
        private ResourceTypeResolver resourceResolver = new ServiceLoaderResourceResolver();
        private Transport transport;

        protected Builder(Collection<Address> members) {
            this.clientBuilder = CopycatClient.builder(members).withServerSelectionStrategy(ServerSelectionStrategies.ANY).withConnectionStrategy(ConnectionStrategies.FIBONACCI_BACKOFF).withRecoveryStrategy(RecoveryStrategies.RECOVER).withRetryStrategy(RetryStrategies.FIBONACCI_BACKOFF);
        }

        public Builder withTransport(Transport transport) {
            this.clientBuilder.withTransport(transport);
            this.transport = transport;
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.clientBuilder.withSerializer(serializer);
            return this;
        }

        public Builder withResourceResolver(ResourceTypeResolver resolver) {
            this.resourceResolver = Assert.notNull(resolver, "resolver");
            return this;
        }

        @Override
        public ResourceClient build() {
            if (this.transport == null) {
                try {
                    this.transport = (Transport)Class.forName("io.atomix.catalyst.transport.NettyTransport").newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new ConfigurationException("transport not configured", new Object[0]);
                }
            }
            ResourceRegistry registry = new ResourceRegistry();
            this.resourceResolver.resolve(registry);
            CopycatClient client = this.clientBuilder.build();
            client.serializer().resolve(new ResourceManagerTypeResolver(registry));
            return new ResourceClient(this.clientBuilder.build(), registry);
        }
    }
}

