/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager;

import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.manager.state.CloseResource;
import io.atomix.manager.state.DeleteResource;
import io.atomix.manager.state.GetResource;
import io.atomix.manager.state.GetResourceIfExists;
import io.atomix.manager.state.GetResourceKeys;
import io.atomix.manager.state.ResourceExists;
import io.atomix.resource.InstanceTypeResolver;
import io.atomix.resource.ResourceCommand;
import io.atomix.resource.ResourceException;
import io.atomix.resource.ResourceQuery;
import io.atomix.resource.ResourceRegistry;
import io.atomix.resource.ResourceStateMachine;
import io.atomix.resource.ResourceType;

public class ResourceManagerTypeResolver
implements SerializableTypeResolver {
    private final ResourceRegistry resourceRegistry;

    public ResourceManagerTypeResolver(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }

    @Override
    public void resolve(SerializerRegistry registry) {
        registry.resolve(new InstanceTypeResolver());
        registry.register(ResourceCommand.class, -50);
        registry.register(ResourceQuery.class, -51);
        registry.register(ResourceStateMachine.ConfigureCommand.class, -52);
        registry.register(ResourceStateMachine.DeleteCommand.class, -53);
        for (ResourceType type : this.resourceRegistry.types()) {
            try {
                registry.resolve(type.typeResolver().newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ResourceException("failed to instantiate resource type resolver", new Object[0]);
            }
        }
        registry.register(GetResource.class, -58);
        registry.register(GetResourceIfExists.class, -59);
        registry.register(GetResourceKeys.class, -60);
        registry.register(ResourceExists.class, -61);
        registry.register(CloseResource.class, -62);
        registry.register(DeleteResource.class, -63);
    }
}

