/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager;

import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.Managed;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.manager.ResourceManagerTypeResolver;
import io.atomix.manager.state.ResourceManagerState;
import io.atomix.resource.ResourceRegistry;
import io.atomix.resource.ResourceTypeResolver;
import io.atomix.resource.ServiceLoaderResourceResolver;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public final class ResourceServer
implements Managed<ResourceServer> {
    private final CopycatServer server;

    public static Builder builder(Address address, Address ... members) {
        return ResourceServer.builder(address, Arrays.asList((Object[])Assert.notNull(members, "members")));
    }

    public static Builder builder(Address address, Collection<Address> members) {
        return new Builder(address, address, Assert.notNull(members, "members"));
    }

    public static Builder builder(Address clientAddress, Address serverAddress, Address ... members) {
        return ResourceServer.builder(clientAddress, serverAddress, Arrays.asList((Object[])Assert.notNull(members, "members")));
    }

    public static Builder builder(Address clientAddress, Address serverAddress, Collection<Address> members) {
        return new Builder(clientAddress, serverAddress, Assert.notNull(members, "members"));
    }

    public ResourceServer(CopycatServer server) {
        this.server = Assert.notNull(server, "server");
    }

    public ThreadContext context() {
        return this.server.context();
    }

    public Serializer serializer() {
        return this.server.serializer();
    }

    public CopycatServer server() {
        return this.server;
    }

    @Override
    public CompletableFuture<ResourceServer> open() {
        return this.server.open().thenApply(v -> this);
    }

    @Override
    public boolean isOpen() {
        return this.server.isOpen();
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.server.close();
    }

    @Override
    public boolean isClosed() {
        return this.server.isClosed();
    }

    public static class Builder
    implements io.atomix.catalyst.util.Builder<ResourceServer> {
        private static final String SERVER_NAME = "atomix";
        private final CopycatServer.Builder builder;
        private ResourceTypeResolver resourceResolver = new ServiceLoaderResourceResolver();

        private Builder(Address clientAddress, Address serverAddress, Collection<Address> members) {
            this.builder = CopycatServer.builder(clientAddress, serverAddress, members).withName(SERVER_NAME);
        }

        public Builder withTransport(Transport transport) {
            this.builder.withTransport(transport);
            return this;
        }

        public Builder withClientTransport(Transport transport) {
            this.builder.withClientTransport(transport);
            return this;
        }

        public Builder withServerTransport(Transport transport) {
            this.builder.withServerTransport(transport);
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.builder.withSerializer(serializer);
            return this;
        }

        public Builder withResourceResolver(ResourceTypeResolver resolver) {
            this.resourceResolver = Assert.notNull(resolver, "resolver");
            return this;
        }

        public Builder withStorage(Storage storage) {
            this.builder.withStorage(storage);
            return this;
        }

        public Builder withElectionTimeout(Duration electionTimeout) {
            this.builder.withElectionTimeout(electionTimeout);
            return this;
        }

        public Builder withHeartbeatInterval(Duration heartbeatInterval) {
            this.builder.withHeartbeatInterval(heartbeatInterval);
            return this;
        }

        public Builder withSessionTimeout(Duration sessionTimeout) {
            this.builder.withSessionTimeout(sessionTimeout);
            return this;
        }

        @Override
        public ResourceServer build() {
            ResourceRegistry registry = new ResourceRegistry();
            this.resourceResolver.resolve(registry);
            CopycatServer server = this.builder.withStateMachine(() -> new ResourceManagerState(registry)).build();
            server.serializer().resolve(new ResourceManagerTypeResolver(registry));
            return new ResourceServer(server);
        }
    }
}

