/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager.state;

import io.atomix.copycat.Operation;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.manager.state.ResourceManagerCommitPool;
import io.atomix.resource.InstanceOperation;
import java.time.Instant;

class ResourceManagerCommit
implements Commit {
    private final ResourceManagerCommitPool pool;
    private Commit<InstanceOperation<?, ?>> commit;
    private ServerSession session;
    private volatile boolean open;

    public ResourceManagerCommit(ResourceManagerCommitPool pool) {
        this.pool = pool;
    }

    void reset(Commit<InstanceOperation<?, ?>> commit, ServerSession session) {
        this.commit = commit;
        this.session = session;
        this.open = true;
    }

    @Override
    public long index() {
        return this.commit.index();
    }

    @Override
    public ServerSession session() {
        return this.session;
    }

    @Override
    public Instant time() {
        return this.commit.time();
    }

    public Class<?> type() {
        return this.commit.operation().operation().getClass();
    }

    public Operation<?> operation() {
        return this.commit.operation().operation();
    }

    @Override
    public void close() {
        if (this.open) {
            this.commit.close();
            this.pool.release(this);
            this.open = false;
        }
    }

    public String toString() {
        return String.format("%s[index=%d, session=%s, time=%s, operation=%s]", this.getClass().getSimpleName(), this.index(), this.session(), this.time(), this.operation());
    }
}

