/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.messaging.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Command;
import io.atomix.messaging.Message;
import java.util.Map;
import java.util.Set;

public final class MessageBusCommands {
    private MessageBusCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        @Override
        public void resolve(SerializerRegistry registry) {
            registry.register(Join.class, -145);
            registry.register(Leave.class, -146);
            registry.register(Register.class, -147);
            registry.register(Unregister.class, -148);
            registry.register(ConsumerInfo.class, -149);
            registry.register(Message.class, -106);
        }
    }

    public static class ConsumerInfo
    implements CatalystSerializable {
        private String topic;
        private Address address;

        public ConsumerInfo() {
        }

        public ConsumerInfo(String topic, Address address) {
            this.topic = topic;
            this.address = address;
        }

        public String topic() {
            return this.topic;
        }

        public Address address() {
            return this.address;
        }

        public void writeObject(BufferOutput buffer, Serializer serializer) {
            buffer.writeString(this.topic);
            serializer.writeObject(this.address, buffer);
        }

        public void readObject(BufferInput buffer, Serializer serializer) {
            this.topic = buffer.readString();
            this.address = (Address)serializer.readObject(buffer);
        }
    }

    public static class Unregister
    extends MessageBusCommand<Void> {
        private String topic;

        public Unregister() {
        }

        public Unregister(String topic) {
            this.topic = Assert.notNull(topic, "topic");
        }

        public String topic() {
            return this.topic;
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            buffer.writeString(this.topic);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            this.topic = buffer.readString();
        }
    }

    public static class Register
    extends MessageBusCommand<Void> {
        private String topic;

        public Register() {
        }

        public Register(String topic) {
            this.topic = Assert.notNull(topic, "topic");
        }

        public String topic() {
            return this.topic;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            buffer.writeString(this.topic);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            this.topic = buffer.readString();
        }
    }

    public static class Leave
    extends MessageBusCommand<Void> {
        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class Join
    extends MessageBusCommand<Map<String, Set<Address>>> {
        protected Address address;

        public Join() {
        }

        public Join(Address address) {
            this.address = Assert.notNull(address, "address");
        }

        public Address member() {
            return this.address;
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            this.address = (Address)serializer.readObject(buffer);
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            serializer.writeObject(this.address, buffer);
        }
    }

    public static abstract class MessageBusCommand<V>
    implements Command<V>,
    CatalystSerializable {
        @Override
        public Command.ConsistencyLevel consistency() {
            return Command.ConsistencyLevel.LINEARIZABLE;
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }

        public void writeObject(BufferOutput buffer, Serializer serializer) {
        }

        public void readObject(BufferInput buffer, Serializer serializer) {
        }
    }
}

