/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.messaging.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.copycat.Command;

public final class TaskQueueCommands {
    private TaskQueueCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        @Override
        public void resolve(SerializerRegistry registry) {
            registry.register(Subscribe.class, -150);
            registry.register(Unsubscribe.class, -151);
            registry.register(Submit.class, -107);
            registry.register(Ack.class, -108);
        }
    }

    public static class Unsubscribe
    extends TaskQueueCommand<Void> {
        @Override
        public Command.ConsistencyLevel consistency() {
            return Command.ConsistencyLevel.LINEARIZABLE;
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class Subscribe
    extends TaskQueueCommand<Void> {
        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }

        @Override
        public Command.ConsistencyLevel consistency() {
            return Command.ConsistencyLevel.LINEARIZABLE;
        }
    }

    public static class Ack
    extends TaskQueueCommand<Object> {
    }

    public static class Submit
    extends TaskQueueCommand<Void> {
        private long id;
        private Object task;
        private boolean ack;

        public Submit() {
        }

        public Submit(long id, Object task, boolean ack) {
            this.id = id;
            this.task = task;
            this.ack = ack;
        }

        public long id() {
            return this.id;
        }

        public Object task() {
            return this.task;
        }

        public boolean ack() {
            return this.ack;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeLong(this.id).writeBoolean(this.ack);
            serializer.writeObject(this.task, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.id = buffer.readLong();
            this.ack = buffer.readBoolean();
            this.task = serializer.readObject(buffer);
        }
    }

    public static abstract class TaskQueueCommand<T>
    implements Command<T>,
    CatalystSerializable {
        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

