/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.messaging.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.copycat.Command;

public final class TopicCommands {
    private TopicCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        @Override
        public void resolve(SerializerRegistry registry) {
            registry.register(Listen.class, -152);
            registry.register(Unlisten.class, -153);
            registry.register(Publish.class, -109);
        }
    }

    public static class Publish<T>
    extends TopicCommand<Void> {
        private T message;

        public Publish() {
        }

        public Publish(T message) {
            this.message = message;
        }

        public T message() {
            return this.message;
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            serializer.writeObject(this.message, buffer);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            this.message = serializer.readObject(buffer);
        }
    }

    public static class Unlisten
    extends TopicCommand<Void> {
        @Override
        public Command.ConsistencyLevel consistency() {
            return Command.ConsistencyLevel.LINEARIZABLE;
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class Listen
    extends TopicCommand<Void> {
        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }

        @Override
        public Command.ConsistencyLevel consistency() {
            return Command.ConsistencyLevel.LINEARIZABLE;
        }
    }

    public static abstract class TopicCommand<V>
    implements Command<V>,
    CatalystSerializable {
        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }

        public void writeObject(BufferOutput buffer, Serializer serializer) {
        }

        public void readObject(BufferInput buffer, Serializer serializer) {
        }
    }
}

