/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.messaging.state;

import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.session.Session;
import io.atomix.messaging.DistributedTopic;
import io.atomix.messaging.state.TopicCommands;
import io.atomix.resource.ResourceStateMachine;
import io.atomix.resource.ResourceType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TopicState
extends ResourceStateMachine
implements SessionListener {
    private final Map<Long, Commit<TopicCommands.Listen>> listeners = new HashMap<Long, Commit<TopicCommands.Listen>>();

    public TopicState() {
        super(new ResourceType(DistributedTopic.class));
    }

    @Override
    public void close(ServerSession session) {
        this.listeners.remove(session.id());
    }

    public void listen(Commit<TopicCommands.Listen> commit) {
        if (!this.listeners.containsKey(commit.session().id())) {
            this.listeners.put(commit.session().id(), commit);
        } else {
            commit.close();
        }
    }

    public void unlisten(Commit<TopicCommands.Unlisten> commit) {
        try {
            Commit<TopicCommands.Listen> listener = this.listeners.remove(commit.session().id());
            if (listener != null) {
                listener.close();
            }
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Commit<TopicCommands.Publish> commit) {
        try {
            Iterator<Map.Entry<Long, Commit<TopicCommands.Listen>>> iterator = this.listeners.entrySet().iterator();
            while (iterator.hasNext()) {
                Commit<TopicCommands.Listen> listener = iterator.next().getValue();
                if (listener.session().state() == Session.State.OPEN) {
                    listener.session().publish("message", commit.operation().message());
                    continue;
                }
                iterator.remove();
                listener.close();
            }
        }
        finally {
            commit.close();
        }
    }

    @Override
    public void delete() {
        this.listeners.values().forEach(Commit::close);
        this.listeners.clear();
    }
}

