/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.util.Assert;
import io.atomix.resource.ResourceType;
import java.util.function.Consumer;

public final class Instance
implements AutoCloseable {
    private final String key;
    private final ResourceType type;
    private final Method method;
    private final Consumer<Instance> closer;

    public Instance(String key, ResourceType type, Method method, Consumer<Instance> closer) {
        this.key = Assert.notNull(key, "key");
        this.type = Assert.notNull(type, "type");
        this.method = Assert.notNull(method, "method");
        this.closer = Assert.notNull(closer, "closer");
    }

    public String key() {
        return this.key;
    }

    public ResourceType type() {
        return this.type;
    }

    public Method method() {
        return this.method;
    }

    @Override
    public void close() {
        this.closer.accept(this);
    }

    public String toString() {
        return String.format("%s[key=%s, type=%s, method=%s]", new Object[]{this.getClass().getSimpleName(), this.key, this.type, this.method});
    }

    public static enum Method {
        GET,
        CREATE;

    }
}

