/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.Listener;
import io.atomix.catalyst.util.concurrent.Futures;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.copycat.session.Session;
import io.atomix.manager.state.CloseResource;
import io.atomix.manager.state.DeleteResource;
import io.atomix.manager.state.GetResource;
import io.atomix.resource.Instance;
import io.atomix.resource.InstanceCommand;
import io.atomix.resource.InstanceEvent;
import io.atomix.resource.InstanceQuery;
import io.atomix.resource.InstanceSession;
import io.atomix.resource.ResourceStateMachine;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;

public final class InstanceClient
implements CopycatClient {
    private volatile long resource;
    private final Instance instance;
    private final CopycatClient client;
    private volatile Session clientSession;
    private volatile InstanceSession session;
    private volatile CopycatClient.State state;
    private final Listener<CopycatClient.State> changeListener;
    private final Map<String, Set<EventListener>> eventListeners = new ConcurrentHashMap<String, Set<EventListener>>();
    private final Map<String, Listener<InstanceEvent<?>>> listeners = new ConcurrentHashMap();
    private final Set<StateChangeListener> changeListeners = new CopyOnWriteArraySet<StateChangeListener>();
    private volatile CompletableFuture<CopycatClient> openFuture;
    private volatile CompletableFuture<CopycatClient> recoverFuture;
    private volatile CompletableFuture<Void> closeFuture;

    public InstanceClient(Instance instance, CopycatClient client) {
        this.instance = Assert.notNull(instance, "instance");
        this.client = Assert.notNull(client, "client");
        this.state = CopycatClient.State.CLOSED;
        this.changeListener = client.onStateChange(this::onStateChange);
    }

    @Override
    public CopycatClient.State state() {
        return this.state;
    }

    private void onStateChange(CopycatClient.State state) {
        if (this.state != CopycatClient.State.CLOSED && this.state != state) {
            if (!this.client.session().equals(this.clientSession)) {
                this.clientSession = this.client.session();
                if (this.state != CopycatClient.State.SUSPENDED) {
                    this.state = CopycatClient.State.SUSPENDED;
                    this.changeListeners.forEach(l -> l.accept(state));
                }
                this.recover();
            } else {
                this.state = state;
                this.changeListeners.forEach(l -> l.accept(state));
            }
        }
    }

    @Override
    public Listener<CopycatClient.State> onStateChange(Consumer<CopycatClient.State> callback) {
        return this.client.onStateChange(callback);
    }

    @Override
    public ThreadContext context() {
        return this.client.context();
    }

    @Override
    public Transport transport() {
        return this.client.transport();
    }

    @Override
    public Session session() {
        return this.session;
    }

    @Override
    public Serializer serializer() {
        return this.client.serializer();
    }

    @Override
    public <T> CompletableFuture<T> submit(Command<T> command) {
        if (command instanceof ResourceStateMachine.DeleteCommand) {
            return ((CompletableFuture)this.client.submit(new InstanceCommand(this.resource, command)).thenCompose(v -> this.client.submit(new DeleteResource(this.resource)))).thenApply(result -> null);
        }
        return this.client.submit(new InstanceCommand(this.resource, command));
    }

    @Override
    public <T> CompletableFuture<T> submit(Query<T> query) {
        return this.client.submit(new InstanceQuery(this.resource, query));
    }

    @Override
    public Listener<Void> onEvent(String event, Runnable callback) {
        return this.onEvent(event, (T v) -> callback.run());
    }

    @Override
    public synchronized <T> Listener<T> onEvent(String event, Consumer<T> listener) {
        Assert.notNull(event, "event");
        Assert.notNull(listener, "listener");
        Set<EventListener> listeners = this.eventListeners.get(event);
        if (listeners == null) {
            listeners = new HashSet<EventListener>();
            this.eventListeners.put(event, listeners);
            this.listeners.put(event, this.client.onEvent(event, (T message) -> this.handleEvent(event, (InstanceEvent<?>)message)));
        }
        EventListener context = new EventListener(event, listener);
        listeners.add(context);
        return context;
    }

    private void handleEvent(String event, InstanceEvent<?> message) {
        Set<EventListener> listeners;
        if (message.resource() == this.resource && (listeners = this.eventListeners.get(event)) != null) {
            for (EventListener listener : listeners) {
                listener.accept(message.message());
            }
        }
    }

    @Override
    public synchronized CompletableFuture<CopycatClient> open() {
        if (this.state != CopycatClient.State.CLOSED) {
            return Futures.exceptionalFuture(new IllegalStateException("client already open"));
        }
        if (this.openFuture == null) {
            this.openFuture = this.client.submit(new GetResource(this.instance.key(), this.instance.type().id())).thenApply(this::completeOpen);
        }
        return this.openFuture;
    }

    private synchronized CopycatClient completeOpen(long resourceId) {
        this.resource = resourceId;
        this.clientSession = this.client.session();
        this.session = new InstanceSession(resourceId, this.clientSession, this.client.context());
        this.state = CopycatClient.State.CONNECTED;
        this.changeListeners.forEach(l -> l.accept(CopycatClient.State.CONNECTED));
        this.openFuture = null;
        this.recoverFuture = null;
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.client.isOpen();
    }

    @Override
    public synchronized CompletableFuture<CopycatClient> recover() {
        if (this.state != CopycatClient.State.SUSPENDED) {
            return Futures.exceptionalFuture(new IllegalStateException("client not suspended"));
        }
        if (this.recoverFuture == null) {
            this.recoverFuture = this.client.submit(new GetResource(this.instance.key(), this.instance.type().id())).thenApply(this::completeOpen);
        }
        return this.recoverFuture;
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        if (this.state == CopycatClient.State.CLOSED) {
            return Futures.exceptionalFuture(new IllegalStateException("client already closed"));
        }
        if (this.closeFuture == null) {
            this.closeFuture = this.client.submit(new CloseResource(this.resource)).whenComplete((result, error) -> {
                InstanceClient instanceClient = this;
                synchronized (instanceClient) {
                    this.instance.close();
                    this.changeListener.close();
                    for (Map.Entry<String, Listener<InstanceEvent<?>>> entry : this.listeners.entrySet()) {
                        entry.getValue().close();
                    }
                    this.listeners.clear();
                    this.state = CopycatClient.State.CLOSED;
                    this.changeListeners.forEach(l -> l.accept(CopycatClient.State.CLOSED));
                    this.closeFuture = null;
                }
            });
        }
        return this.closeFuture;
    }

    @Override
    public boolean isClosed() {
        return this.client.isClosed();
    }

    public String toString() {
        return String.format("%s[resource=%d]", this.getClass().getSimpleName(), this.resource);
    }

    private class StateChangeListener
    implements Listener<CopycatClient.State> {
        private final Consumer<CopycatClient.State> callback;

        private StateChangeListener(Consumer<CopycatClient.State> callback) {
            this.callback = callback;
            InstanceClient.this.changeListeners.add(this);
        }

        @Override
        public void accept(CopycatClient.State state) {
            this.callback.accept(state);
        }

        @Override
        public void close() {
            InstanceClient.this.changeListeners.remove(this);
        }
    }

    private class EventListener<T>
    implements Listener<T> {
        private final String event;
        private final Consumer<T> listener;

        private EventListener(String event, Consumer<T> listener) {
            this.event = event;
            this.listener = listener;
        }

        @Override
        public void accept(T event) {
            this.listener.accept(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            InstanceClient instanceClient = InstanceClient.this;
            synchronized (instanceClient) {
                Set listeners = (Set)InstanceClient.this.eventListeners.get(this.event);
                if (listeners != null) {
                    listeners.remove(this);
                    if (listeners.isEmpty()) {
                        InstanceClient.this.eventListeners.remove(this.event);
                        Listener listener = (Listener)InstanceClient.this.listeners.remove(this.event);
                        if (listener != null) {
                            listener.close();
                        }
                    }
                }
            }
        }
    }
}

