/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.Listener;
import io.atomix.catalyst.util.Managed;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.ResourceCommand;
import io.atomix.resource.ResourceException;
import io.atomix.resource.ResourceQuery;
import io.atomix.resource.ResourceStateMachine;
import io.atomix.resource.ResourceType;
import io.atomix.resource.WriteConsistency;
import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;

public abstract class Resource<T extends Resource<T>>
implements Managed<T> {
    private final ResourceType type;
    protected final CopycatClient client;
    protected final Options options;
    private State state;
    private final Set<StateChangeListener> changeListeners = new CopyOnWriteArraySet<StateChangeListener>();
    private WriteConsistency writeConsistency = WriteConsistency.ATOMIC;
    private ReadConsistency readConsistency = ReadConsistency.ATOMIC;

    protected Resource(CopycatClient client, Options options) {
        this.type = new ResourceType(this.getClass());
        this.client = Assert.notNull(client, "client");
        client.serializer().register(ResourceCommand.class, -50);
        client.serializer().register(ResourceQuery.class, -51);
        client.serializer().register(ResourceStateMachine.ConfigureCommand.class, -52);
        client.serializer().register(ResourceStateMachine.DeleteCommand.class, -53);
        try {
            client.serializer().resolve(this.type.typeResolver().newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ResourceException("failed to instantiate resource type resolver");
        }
        this.options = options;
        client.onStateChange(this::onStateChange);
    }

    private void onStateChange(CopycatClient.State state) {
        this.state = State.valueOf(state.name());
        this.changeListeners.forEach(l -> l.accept(this.state));
    }

    public ResourceType type() {
        return this.type;
    }

    public State state() {
        return this.state;
    }

    public Listener<State> onStateChange(Consumer<State> callback) {
        return new StateChangeListener(Assert.notNull(callback, "callback"));
    }

    public ThreadContext context() {
        return this.client.context();
    }

    public CompletableFuture<T> configure(Config config) {
        return this.client.submit(new ResourceStateMachine.ConfigureCommand(config)).thenApply(v -> this);
    }

    public WriteConsistency writeConsistency() {
        return this.writeConsistency;
    }

    public T with(WriteConsistency consistency) {
        this.writeConsistency = Assert.notNull(consistency, "consistency");
        return (T)this;
    }

    public ReadConsistency readConsistency() {
        return this.readConsistency;
    }

    public T with(ReadConsistency consistency) {
        this.readConsistency = Assert.notNull(consistency, "consistency");
        return (T)this;
    }

    protected <R> CompletableFuture<R> submit(Command<R> command) {
        return this.client.submit(new ResourceCommand(Assert.notNull(command, "command"), this.writeConsistency.level()));
    }

    protected <R> CompletableFuture<R> submit(Command<R> command, WriteConsistency consistency) {
        return this.client.submit(new ResourceCommand(Assert.notNull(command, "command"), consistency.level()));
    }

    protected <R> CompletableFuture<R> submit(Query<R> query) {
        return this.client.submit(new ResourceQuery(Assert.notNull(query, "query"), this.readConsistency.level()));
    }

    protected <R> CompletableFuture<R> submit(Query<R> query, ReadConsistency consistency) {
        return this.client.submit(new ResourceQuery(Assert.notNull(query, "query"), consistency.level()));
    }

    @Override
    public CompletableFuture<T> open() {
        return this.client.open().thenApply(v -> this);
    }

    @Override
    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.client.close();
    }

    @Override
    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    public CompletableFuture<Void> delete() {
        return this.client.submit(new ResourceStateMachine.DeleteCommand());
    }

    public int hashCode() {
        return 851 + this.client.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof Resource && ((Resource)object).client.session().id() == this.client.session().id();
    }

    public String toString() {
        return String.format("%s[id=%s]", this.getClass().getSimpleName(), this.client.session().id());
    }

    private class StateChangeListener
    implements Listener<State> {
        private final Consumer<State> callback;

        private StateChangeListener(Consumer<State> callback) {
            this.callback = callback;
            Resource.this.changeListeners.add(this);
        }

        @Override
        public void accept(State state) {
            this.callback.accept(state);
        }

        @Override
        public void close() {
            Resource.this.changeListeners.remove(this);
        }
    }

    public static enum State {
        CONNECTED,
        SUSPENDED,
        CLOSED;

    }

    public static class Options
    extends Properties {
        public Options() {
        }

        public Options(Properties defaults) {
            super(defaults);
        }
    }

    public static class Config
    extends Properties
    implements Serializable {
        public Config() {
        }

        public Config(Properties defaults) {
            super(defaults);
        }
    }
}

