/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.copycat.Command;
import io.atomix.resource.ResourceOperation;

public final class ResourceCommand<T extends Command<U>, U>
extends ResourceOperation<T, U>
implements Command<U> {
    private Command.ConsistencyLevel consistency;

    public ResourceCommand() {
    }

    public ResourceCommand(T command, Command.ConsistencyLevel consistency) {
        super(command);
        this.consistency = consistency;
    }

    @Override
    public Command.ConsistencyLevel consistency() {
        Command.ConsistencyLevel consistency = ((Command)this.operation).consistency();
        return consistency != null ? consistency : this.consistency;
    }

    @Override
    public Command.CompactionMode compaction() {
        return ((Command)this.operation).compaction();
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeByte(this.consistency.ordinal());
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.consistency = Command.ConsistencyLevel.values()[buffer.readByte()];
    }

    @Override
    public String toString() {
        return String.format("%s[command=%s, consistency=%s]", new Object[]{this.getClass().getSimpleName(), this.operation, this.consistency()});
    }
}

