/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.util.Assert;
import io.atomix.resource.ResourceType;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ResourceRegistry {
    private final Map<Integer, ResourceType> resourceTypes = new ConcurrentHashMap<Integer, ResourceType>();

    public Collection<ResourceType> types() {
        return this.resourceTypes.values();
    }

    public ResourceRegistry register(ResourceType type) {
        Assert.notNull(type, "type");
        Assert.argNot(type.id() > Short.MAX_VALUE, "resource ID must be less than %d", (short)Short.MAX_VALUE);
        Assert.argNot(this.resourceTypes.containsKey(type.id()), "a type with the ID %s already exists", type.id());
        this.resourceTypes.put(type.id(), type);
        return this;
    }

    public ResourceType lookup(int id) {
        return this.resourceTypes.get(id);
    }

    public String toString() {
        return String.format("%s%s", this.getClass().getSimpleName(), this.resourceTypes.values());
    }
}

