/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Command;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachine;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.resource.ResourceCommand;
import io.atomix.resource.ResourceException;
import io.atomix.resource.ResourceQuery;
import io.atomix.resource.ResourceStateMachineExecutor;
import io.atomix.resource.ResourceType;
import java.util.Properties;

public abstract class ResourceStateMachine
extends StateMachine
implements SessionListener {
    private final ResourceType type;
    private Commit<ConfigureCommand> configureCommit;

    protected ResourceStateMachine(ResourceType type) {
        this.type = Assert.notNull(type, "type");
    }

    @Override
    public final void init(StateMachineExecutor executor) {
        try {
            executor.serializer().resolve(this.type.typeResolver().newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ResourceException("failed to instantiate resource type resolver");
        }
        executor.serializer().register(ResourceCommand.class, -50);
        executor.serializer().register(ResourceQuery.class, -51);
        executor.serializer().register(ConfigureCommand.class, -52);
        executor.serializer().register(DeleteCommand.class, -53);
        executor.register(DeleteCommand.class, this::delete);
        executor.register(ConfigureCommand.class, this::configure);
        super.init(new ResourceStateMachineExecutor(executor));
    }

    private void configure(Commit<ConfigureCommand> commit) {
        if (this.configureCommit != null) {
            this.configureCommit.close();
        }
        this.configureCommit = commit;
        this.configure(this.configureCommit.operation().config());
    }

    public void configure(Properties config) {
    }

    @Override
    public void register(ServerSession session) {
    }

    @Override
    public void unregister(ServerSession session) {
    }

    @Override
    public void expire(ServerSession session) {
    }

    @Override
    public void close(ServerSession session) {
    }

    private void delete(Commit<DeleteCommand> commit) {
        try {
            this.delete();
        }
        finally {
            commit.close();
        }
    }

    public void delete() {
    }

    public static class DeleteCommand
    implements Command<Void>,
    CatalystSerializable {
        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }

    public static class ConfigureCommand
    implements Command<Void>,
    CatalystSerializable {
        private Properties config;

        public ConfigureCommand() {
        }

        public ConfigureCommand(Properties config) {
            this.config = Assert.notNull(config, "config");
        }

        public Properties config() {
            return this.config;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject(this.config, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.config = (Properties)serializer.readObject(buffer);
        }
    }
}

