/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceException;
import io.atomix.resource.ResourceFactory;
import io.atomix.resource.ResourceStateMachine;
import io.atomix.resource.ResourceTypeInfo;

public class ResourceType {
    private final Class<? extends Resource> type;
    private final int id;
    private final Class<? extends ResourceStateMachine> stateMachine;
    private final Class<? extends SerializableTypeResolver> typeResolver;

    public ResourceType(Class<? extends Resource> type) {
        this.type = Assert.notNull(type, "type");
        ResourceTypeInfo info = type.getAnnotation(ResourceTypeInfo.class);
        if (info == null) {
            throw new IllegalArgumentException("resource type not annotated");
        }
        this.id = info.id();
        this.stateMachine = info.stateMachine();
        this.typeResolver = info.typeResolver();
    }

    public int id() {
        return this.id;
    }

    public Class<? extends Resource> resource() {
        return this.type;
    }

    public ResourceFactory factory() {
        return (client, options) -> {
            try {
                return this.resource().getConstructor(CopycatClient.class, Resource.Options.class).newInstance(client, options);
            }
            catch (ReflectiveOperationException e) {
                throw new ResourceException("failed to instantiate resource class", (Throwable)e);
            }
        };
    }

    public Class<? extends ResourceStateMachine> stateMachine() {
        return this.stateMachine;
    }

    public Class<? extends SerializableTypeResolver> typeResolver() {
        return this.typeResolver;
    }

    public int hashCode() {
        int hashCode = 23;
        hashCode = 37 * hashCode + this.type.hashCode();
        hashCode = 37 * hashCode + this.id;
        return hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof ResourceType) {
            ResourceType resourceType = (ResourceType)object;
            return resourceType.type == this.type && resourceType.id == this.id;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[id=%d, type=%s, state=%s]", this.getClass().getSimpleName(), this.id, this.type, this.stateMachine);
    }
}

