/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.CatalystException;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceRegistry;
import io.atomix.resource.ResourceType;
import io.atomix.resource.ResourceTypeResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ServiceLoaderResourceResolver
implements ResourceTypeResolver {
    @Override
    public void resolve(ResourceRegistry registry) {
        for (Class<Resource> resourceType : this.load(Resource.class)) {
            registry.register(new ResourceType(resourceType));
        }
    }

    private <T> List<Class<? extends T>> load(Class<T> clazz) {
        Enumeration<URL> urls;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            urls = cl.getResources(String.format("META-INF/services/%s", clazz.getName()));
        }
        catch (IOException e) {
            throw new CatalystException(e);
        }
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            try {
                String line;
                InputStream is = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    int comment = line.lastIndexOf(35);
                    if (comment >= 0) {
                        line = line.substring(0, line.lastIndexOf(35));
                    }
                    if ((line = line.trim()).length() <= 0) continue;
                    try {
                        classes.add(cl.loadClass(line));
                    }
                    catch (ClassNotFoundException e) {
                        throw new CatalystException("failed to load class: " + line, e);
                    }
                }
                is.close();
            }
            catch (IOException | IllegalArgumentException | SecurityException e) {
                throw new CatalystException("failed to read services", e);
            }
        }
        return classes;
    }
}

