/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.util;

import io.atomix.Quorum;
import io.atomix.copycat.server.cluster.Cluster;
import io.atomix.copycat.server.cluster.Member;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterBalancer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterBalancer.class);
    private final int quorumHint;
    private final int backupCount;
    private boolean closed;

    public ClusterBalancer(int quorumHint, int backupCount) {
        this.quorumHint = quorumHint;
        this.backupCount = backupCount;
    }

    public CompletableFuture<Void> balance(Cluster cluster) {
        LOGGER.info("Balancing cluster...");
        return this.balance(cluster, new CompletableFuture<Void>());
    }

    private CompletableFuture<Void> balance(Cluster cluster, CompletableFuture<Void> future) {
        if (this.closed) {
            future.completeExceptionally(new IllegalStateException("balancer closed"));
            return future;
        }
        Collection<Member> members = cluster.members();
        Member member = cluster.member();
        Collection active = members.stream().filter(m -> m.type() == Member.Type.ACTIVE).collect(Collectors.toList());
        Collection passive = members.stream().filter(m -> m.type() == Member.Type.PASSIVE).collect(Collectors.toList());
        Collection reserve = members.stream().filter(m -> m.type() == Member.Type.RESERVE).collect(Collectors.toList());
        int totalActiveCount = active.size();
        int totalPassiveCount = passive.size();
        long availableActiveCount = active.stream().filter(m -> m.status() == Member.Status.AVAILABLE).count();
        long availablePassiveCount = passive.stream().filter(m -> m.status() == Member.Status.AVAILABLE).count();
        long availableReserveCount = reserve.stream().filter(m -> m.status() == Member.Status.AVAILABLE).count();
        BiConsumer<Void, Throwable> completeFunction = (result, error) -> {
            if (error == null) {
                this.balance(cluster, future);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        };
        if (this.quorumHint == Quorum.ALL.size() || availableActiveCount < (long)this.quorumHint) {
            if (availablePassiveCount > 0L) {
                Member promote = passive.stream().filter(m -> m.status() == Member.Status.AVAILABLE).findFirst().get();
                LOGGER.info("Promoting {} to ACTIVE: not enough active members", (Object)promote.address());
                promote.promote(Member.Type.ACTIVE).whenComplete((BiConsumer)completeFunction);
                return future;
            }
            if (availableReserveCount > 0L) {
                Member promote = reserve.stream().filter(m -> m.status() == Member.Status.AVAILABLE).findFirst().get();
                LOGGER.info("Promoting {} to ACTIVE: not enough active members", (Object)promote.address());
                promote.promote(Member.Type.ACTIVE).whenComplete((BiConsumer)completeFunction);
                return future;
            }
        }
        if (this.quorumHint != Quorum.ALL.size() && totalActiveCount > this.quorumHint) {
            if (availablePassiveCount < (long)(this.quorumHint * this.backupCount)) {
                Member demote = active.stream().filter(m -> m.status() == Member.Status.UNAVAILABLE).findFirst().orElseGet(() -> active.stream().filter(m -> !m.equals(member)).findAny().get());
                LOGGER.info("Demoting {} to PASSIVE: too many active members", (Object)demote.address());
                demote.demote(Member.Type.PASSIVE).whenComplete((BiConsumer)completeFunction);
                return future;
            }
            Member demote = active.stream().filter(m -> m.status() == Member.Status.UNAVAILABLE).findAny().orElseGet(() -> active.stream().filter(m -> !m.equals(member)).findAny().get());
            LOGGER.info("Demoting {} to RESERVE: too many active members", (Object)demote.address());
            demote.demote(Member.Type.RESERVE).whenComplete((BiConsumer)completeFunction);
            return future;
        }
        if (this.quorumHint != Quorum.ALL.size() && availablePassiveCount < (long)(this.quorumHint * this.backupCount) && availableReserveCount > 0L) {
            Member promote = reserve.stream().filter(m -> m.status() == Member.Status.AVAILABLE).findFirst().get();
            LOGGER.info("Promoting {} to PASSIVE: not enough passive members", (Object)promote.address());
            promote.promote(Member.Type.PASSIVE).whenComplete((BiConsumer)completeFunction);
            return future;
        }
        if (this.quorumHint != Quorum.ALL.size() && totalPassiveCount > this.quorumHint * this.backupCount) {
            Member demote = passive.stream().filter(m -> m.status() == Member.Status.UNAVAILABLE).findAny().orElseGet(() -> (Member)passive.stream().findAny().get());
            LOGGER.info("Demoting {} to RESERVE: too many passive members", (Object)demote.address());
            demote.demote(Member.Type.RESERVE).whenComplete((BiConsumer)completeFunction);
            return future;
        }
        future.complete(null);
        return future;
    }

    public CompletableFuture<Void> replace(Cluster cluster) {
        LOGGER.debug("Balancing cluster...");
        return this.replace(cluster, new CompletableFuture<Void>());
    }

    private CompletableFuture<Void> replace(Cluster cluster, CompletableFuture<Void> future) {
        if (this.closed) {
            future.completeExceptionally(new IllegalStateException("cluster balancer closed"));
            return future;
        }
        BiConsumer<Void, Throwable> completeFunction = (result, error) -> {
            if (error == null) {
                future.complete(null);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        };
        Function<Void, CompletableFuture> demoteFunction = v -> {
            long passiveCount = cluster.members().stream().filter(m -> m.type() == Member.Type.PASSIVE).count();
            if (passiveCount < (long)(this.quorumHint * this.backupCount)) {
                LOGGER.info("Demoting {} to PASSIVE", (Object)cluster.member().address());
                return cluster.member().demote(Member.Type.PASSIVE);
            }
            LOGGER.info("Demoting {} to RESERVE", (Object)cluster.member().address());
            return cluster.member().demote(Member.Type.RESERVE);
        };
        if (this.quorumHint == Quorum.ALL.size()) {
            return CompletableFuture.completedFuture(null);
        }
        if (cluster.member().type() == Member.Type.ACTIVE) {
            Member member;
            Optional<Member> optionalMember;
            Collection passive = cluster.members().stream().filter(m -> m.type() == Member.Type.PASSIVE).collect(Collectors.toList());
            Collection reserve = cluster.members().stream().filter(m -> m.type() == Member.Type.RESERVE).collect(Collectors.toList());
            if (!passive.isEmpty() && (optionalMember = passive.stream().filter(m -> m.status() == Member.Status.AVAILABLE).findFirst()).isPresent()) {
                LOGGER.info("Promoting {} to ACTIVE: replacing {}", (Object)optionalMember.get().address(), (Object)cluster.member().address());
                ((CompletableFuture)optionalMember.get().promote(Member.Type.ACTIVE).thenCompose(demoteFunction)).whenComplete(completeFunction);
                return future;
            }
            if (!reserve.isEmpty() && (optionalMember = reserve.stream().filter(m -> m.status() == Member.Status.AVAILABLE).findFirst()).isPresent()) {
                LOGGER.info("Promoting {} to ACTIVE: replacing {}", (Object)optionalMember.get().address(), (Object)cluster.member().address());
                ((CompletableFuture)optionalMember.get().promote(Member.Type.ACTIVE).thenCompose(demoteFunction)).whenComplete(completeFunction);
                return future;
            }
            if (!passive.isEmpty()) {
                member = (Member)passive.iterator().next();
                LOGGER.info("Promoting {} to ACTIVE: replacing {}", (Object)member.address(), (Object)cluster.member().address());
                ((CompletableFuture)member.promote(Member.Type.ACTIVE).thenCompose(demoteFunction)).whenComplete(completeFunction);
            } else if (!reserve.isEmpty()) {
                member = (Member)reserve.iterator().next();
                LOGGER.info("Promoting {} to ACTIVE: replacing {}", (Object)member.address(), (Object)cluster.member().address());
                ((CompletableFuture)member.promote(Member.Type.ACTIVE).thenCompose(demoteFunction)).whenComplete(completeFunction);
            } else {
                future.complete(null);
            }
        } else if (cluster.member().type() == Member.Type.PASSIVE) {
            Collection reserve = cluster.members().stream().filter(m -> m.type() == Member.Type.RESERVE).collect(Collectors.toList());
            if (!reserve.isEmpty()) {
                Optional<Member> optionalMember = reserve.stream().filter(m -> m.status() == Member.Status.AVAILABLE).findFirst();
                if (optionalMember.isPresent()) {
                    LOGGER.info("Promoting {} to PASSIVE: replacing {}", (Object)optionalMember.get().address(), (Object)cluster.member().address());
                    ((CompletableFuture)optionalMember.get().promote(Member.Type.PASSIVE).thenCompose(demoteFunction)).whenComplete(completeFunction);
                } else {
                    Member member = (Member)reserve.iterator().next();
                    LOGGER.info("Promoting {} to PASSIVE: replacing {}", (Object)member.address(), (Object)cluster.member().address());
                    ((CompletableFuture)member.promote(Member.Type.PASSIVE).thenCompose(demoteFunction)).whenComplete(completeFunction);
                }
            } else {
                future.complete(null);
            }
        } else {
            future.complete(null);
        }
        return future;
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

