/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.variables;

import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import io.atomix.variables.state.ValueCommands;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractDistributedValue<T extends AbstractDistributedValue<T, U>, U>
extends Resource<T> {
    protected AbstractDistributedValue(CopycatClient client, Resource.Options options) {
        super(client, options);
    }

    public CompletableFuture<U> get() {
        return this.submit(new ValueCommands.Get());
    }

    public CompletableFuture<U> get(ReadConsistency consistency) {
        return this.submit(new ValueCommands.Get(), consistency);
    }

    public CompletableFuture<Void> set(U value) {
        return this.submit(new ValueCommands.Set<U>(value));
    }

    public CompletableFuture<Void> set(U value, Duration ttl) {
        return this.submit(new ValueCommands.Set<U>(value, ttl.toMillis()));
    }

    public CompletableFuture<U> getAndSet(U value) {
        return this.submit(new ValueCommands.GetAndSet<U>(value));
    }

    public CompletableFuture<U> getAndSet(U value, Duration ttl) {
        return this.submit(new ValueCommands.GetAndSet<U>(value, ttl.toMillis()));
    }

    public CompletableFuture<Boolean> compareAndSet(U expect, U update) {
        return this.submit(new ValueCommands.CompareAndSet<U>(expect, update));
    }

    public CompletableFuture<Boolean> compareAndSet(U expect, U update, Duration ttl) {
        return this.submit(new ValueCommands.CompareAndSet<U>(expect, update, ttl.toMillis()));
    }
}

