/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.variables.state;

import io.atomix.catalyst.util.concurrent.Scheduled;
import io.atomix.copycat.server.Commit;
import io.atomix.resource.ResourceStateMachine;
import io.atomix.resource.ResourceType;
import io.atomix.variables.state.ValueCommands;
import java.time.Duration;

public class AbstractValueState<T>
extends ResourceStateMachine {
    protected T value;
    protected Commit<? extends ValueCommands.ValueCommand<?>> current;
    protected Scheduled timer;

    public AbstractValueState(ResourceType type) {
        super(type);
    }

    public T get(Commit<ValueCommands.Get<T>> commit) {
        try {
            T t = this.current != null ? (T)this.value : null;
            return t;
        }
        finally {
            commit.close();
        }
    }

    private void cleanCurrent() {
        if (this.current != null) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.current.close();
        }
    }

    private void setCurrent(Commit<? extends ValueCommands.ValueCommand<?>> commit) {
        this.timer = commit.operation().ttl() > 0L ? this.executor.schedule(Duration.ofMillis(commit.operation().ttl()), () -> {
            this.value = null;
            this.current.close();
            this.current = null;
        }) : null;
        this.current = commit;
    }

    public void set(Commit<ValueCommands.Set<T>> commit) {
        this.cleanCurrent();
        this.value = commit.operation().value();
        this.setCurrent(commit);
    }

    public boolean compareAndSet(Commit<ValueCommands.CompareAndSet<T>> commit) {
        if (this.value == null && commit.operation().expect() == null || this.value != null && commit.operation().expect() != null && this.value.equals(commit.operation().expect())) {
            this.value = commit.operation().update();
            this.cleanCurrent();
            this.setCurrent(commit);
            return true;
        }
        commit.close();
        return false;
    }

    public T getAndSet(Commit<ValueCommands.GetAndSet<T>> commit) {
        T result = this.value;
        this.value = commit.operation().value();
        this.cleanCurrent();
        this.setCurrent(commit);
        return result;
    }

    @Override
    public void delete() {
        if (this.current != null) {
            this.current.close();
            this.current = null;
            this.value = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

