/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.variables.state;

import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.Snapshottable;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import io.atomix.resource.ResourceType;
import io.atomix.variables.DistributedLong;
import io.atomix.variables.state.AbstractValueState;
import io.atomix.variables.state.LongCommands;
import io.atomix.variables.state.ValueCommands;
import java.util.concurrent.atomic.AtomicLong;

public class LongState
extends AbstractValueState<Long>
implements Snapshottable {
    private AtomicLong value = new AtomicLong(0L);

    public LongState() {
        super(new ResourceType(DistributedLong.class));
    }

    @Override
    public void snapshot(SnapshotWriter writer) {
        writer.writeLong(this.value.get());
    }

    @Override
    public void install(SnapshotReader reader) {
        this.value = new AtomicLong(reader.readLong());
    }

    @Override
    public void set(Commit<ValueCommands.Set<Long>> commit) {
        try {
            this.value.set(commit.operation().value());
        }
        finally {
            commit.close();
        }
    }

    @Override
    public Long get(Commit<ValueCommands.Get<Long>> commit) {
        try {
            Long l = this.value.get();
            return l;
        }
        finally {
            commit.close();
        }
    }

    @Override
    public Long getAndSet(Commit<ValueCommands.GetAndSet<Long>> commit) {
        try {
            Long l = this.value.getAndSet(commit.operation().value());
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compareAndSet(Commit<ValueCommands.CompareAndSet<Long>> commit) {
        try {
            Long expect = commit.operation().expect();
            Long update = commit.operation().update();
            boolean bl = this.value.compareAndSet(expect, update);
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementAndGet(Commit<LongCommands.IncrementAndGet> commit) {
        try {
            long l = this.value.incrementAndGet();
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decrementAndGet(Commit<LongCommands.DecrementAndGet> commit) {
        try {
            long l = this.value.decrementAndGet();
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAndIncrement(Commit<LongCommands.GetAndIncrement> commit) {
        try {
            long l = this.value.getAndIncrement();
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAndDecrement(Commit<LongCommands.GetAndDecrement> commit) {
        try {
            long l = this.value.getAndDecrement();
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addAndGet(Commit<LongCommands.AddAndGet> commit) {
        try {
            long l = this.value.addAndGet(commit.operation().delta());
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAndAdd(Commit<LongCommands.GetAndAdd> commit) {
        try {
            long l = this.value.getAndAdd(commit.operation().delta());
            return l;
        }
        finally {
            commit.close();
        }
    }
}

