/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat;

import com.typesafe.config.ConfigValueFactory;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatorConfig;
import net.kuujo.copycat.util.AbstractConfigurable;
import net.kuujo.copycat.util.Configurable;
import net.kuujo.copycat.util.ConfigurationException;
import net.kuujo.copycat.util.concurrent.NamedThreadFactory;
import net.kuujo.copycat.util.internal.Assert;
import net.kuujo.copycat.util.serializer.Serializer;

public class CopycatConfig
extends AbstractConfigurable {
    public static final String COPYCAT_NAME = "name";
    public static final String COPYCAT_DEFAULT_SERIALIZER = "serializer";
    public static final String COPYCAT_CLUSTER = "cluster";
    private static final String DEFAULT_CONFIGURATION = "copycat-default";
    private static final String CONFIGURATION = "copycat";
    private ClusterConfig clusterConfig;
    private Serializer defaultSerializer;
    private Executor executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("copycat-%d"));

    public CopycatConfig() {
        super(CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    public CopycatConfig(Map<String, Object> config) {
        super(config, CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    public CopycatConfig(String resource) {
        super(resource, CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    private CopycatConfig(CopycatConfig config) {
        super(config);
    }

    @Override
    public CopycatConfig copy() {
        return new CopycatConfig(this);
    }

    public void setName(String name) {
        this.config = this.config.withValue(COPYCAT_NAME, ConfigValueFactory.fromAnyRef(Assert.isNotNull(name, COPYCAT_NAME)));
    }

    public String getName() {
        return this.config.getString(COPYCAT_NAME);
    }

    public CopycatConfig withName(String name) {
        this.setName(name);
        return this;
    }

    public void setClusterConfig(ClusterConfig cluster) {
        this.config = this.config.withValue(COPYCAT_CLUSTER, ConfigValueFactory.fromMap(Assert.isNotNull(cluster, COPYCAT_CLUSTER).toMap()));
        this.clusterConfig = cluster;
    }

    public ClusterConfig getClusterConfig() {
        return this.clusterConfig != null ? this.clusterConfig : (ClusterConfig)Configurable.load(this.config.getObject(COPYCAT_CLUSTER).unwrapped());
    }

    public CopycatConfig withClusterConfig(ClusterConfig config) {
        this.setClusterConfig(config);
        return this;
    }

    public void setDefaultSerializer(String serializer) {
        try {
            this.setDefaultSerializer((Serializer)Class.forName(serializer).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException("Failed to instantiate serializer", new Object[]{e});
        }
    }

    public void setDefaultSerializer(Class<? extends Serializer> serializer) {
        try {
            this.setDefaultSerializer(serializer.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException("Failed to instantiate serializer", new Object[]{e});
        }
    }

    public void setDefaultSerializer(Serializer serializer) {
        this.defaultSerializer = serializer;
    }

    public Serializer getDefaultSerializer() {
        return this.defaultSerializer != null ? this.defaultSerializer : (Serializer)Configurable.load(this.config.getObject(COPYCAT_DEFAULT_SERIALIZER).unwrapped());
    }

    public CopycatConfig withSerializer(String serializer) {
        this.setDefaultSerializer(serializer);
        return this;
    }

    public CopycatConfig withDefaultSerializer(Class<? extends Serializer> serializer) {
        this.setDefaultSerializer(serializer);
        return this;
    }

    public CopycatConfig withDefaultSerializer(Serializer serializer) {
        this.setDefaultSerializer(serializer);
        return this;
    }

    public void setDefaultExecutor(Executor executor) {
        this.executor = Assert.isNotNull(executor, "executor");
    }

    public Executor getDefaultExecutor() {
        return this.executor;
    }

    public CopycatConfig withDefaultExecutor(Executor executor) {
        this.setDefaultExecutor(executor);
        return this;
    }

    public CoordinatorConfig resolve() {
        return new CoordinatorConfig().withName(this.getName()).withExecutor(this.getDefaultExecutor()).withClusterConfig(this.getClusterConfig());
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.config.root().unwrapped());
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof CopycatConfig && ((CopycatConfig)object).config.equals(this.config);
    }

    @Override
    public int hashCode() {
        return 17 * this.config.root().unwrapped().hashCode();
    }
}

