/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.atomic;

import java.util.Map;
import net.kuujo.copycat.atomic.internal.DefaultAsyncReference;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatedResourceConfig;
import net.kuujo.copycat.collections.AsyncCollectionConfig;
import net.kuujo.copycat.state.StateLogConfig;
import net.kuujo.copycat.util.internal.Assert;

public class AsyncReferenceConfig
extends AsyncCollectionConfig<AsyncReferenceConfig> {
    private static final String DEFAULT_CONFIGURATION = "atomic-defaults";
    private static final String CONFIGURATION = "atomic";

    public AsyncReferenceConfig() {
        super(new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public AsyncReferenceConfig(Map<String, Object> config) {
        super(config, CONFIGURATION, DEFAULT_CONFIGURATION);
    }

    public AsyncReferenceConfig(String resource) {
        super(new String[]{resource, CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    protected AsyncReferenceConfig(AsyncReferenceConfig config) {
        super(config);
    }

    @Override
    public AsyncReferenceConfig copy() {
        return new AsyncReferenceConfig(this);
    }

    @Override
    public CoordinatedResourceConfig resolve(ClusterConfig cluster) {
        Assert.config(this.getReplicas(), this.getReplicas().isEmpty() || cluster.getMembers().containsAll(this.getReplicas()), "Resource replica set must contain only active cluster members", new Object[0]);
        return new StateLogConfig(this.toMap()).resolve(cluster).withResourceType(DefaultAsyncReference.class);
    }
}

