/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.copycat.cluster.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.kuujo.copycat.EventListener;
import net.kuujo.copycat.cluster.Cluster;
import net.kuujo.copycat.cluster.ClusterException;
import net.kuujo.copycat.cluster.ElectionEvent;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.cluster.Members;
import net.kuujo.copycat.cluster.MembershipEvent;
import net.kuujo.copycat.cluster.MessageHandler;
import net.kuujo.copycat.cluster.internal.CoordinatedLocalMember;
import net.kuujo.copycat.cluster.internal.CoordinatedMember;
import net.kuujo.copycat.cluster.internal.CoordinatedMembers;
import net.kuujo.copycat.cluster.internal.MemberInfo;
import net.kuujo.copycat.cluster.internal.Router;
import net.kuujo.copycat.cluster.internal.coordinator.ClusterCoordinator;
import net.kuujo.copycat.cluster.internal.coordinator.MemberCoordinator;
import net.kuujo.copycat.cluster.internal.manager.ClusterManager;
import net.kuujo.copycat.cluster.internal.manager.LocalMemberManager;
import net.kuujo.copycat.cluster.internal.manager.MemberManager;
import net.kuujo.copycat.raft.RaftContext;
import net.kuujo.copycat.util.serializer.KryoSerializer;
import net.kuujo.copycat.util.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCluster
implements ClusterManager,
Observer {
    private static final String JOIN_TOPIC = "*";
    private static final long MEMBER_INFO_EXPIRE_TIME = 60000L;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final int id;
    protected final ClusterCoordinator coordinator;
    protected final Serializer serializer;
    protected final ScheduledExecutorService executor;
    protected final Executor userExecutor;
    private final Serializer internalSerializer = new KryoSerializer();
    private Thread thread;
    private CoordinatedLocalMember localMember;
    private final CoordinatedMembers members;
    private final Map<String, MemberInfo> membersInfo = new HashMap<String, MemberInfo>();
    private final Router router;
    private final RaftContext context;
    private final Set<EventListener<MembershipEvent>> membershipListeners = new CopyOnWriteArraySet<EventListener<MembershipEvent>>();
    private final Map<String, MessageHandler> broadcastHandlers = new ConcurrentHashMap<String, MessageHandler>(1024);
    private final Map<String, Set<EventListener>> broadcastListeners = new ConcurrentHashMap<String, Set<EventListener>>(1024);
    private final Set<EventListener<ElectionEvent>> electionListeners = new CopyOnWriteArraySet<EventListener<ElectionEvent>>();
    private String electedLeader;
    private ScheduledFuture<?> gossipTimer;
    private final Random random = new Random();

    protected AbstractCluster(int id, ClusterCoordinator coordinator, RaftContext context, Router router, Serializer serializer, ScheduledExecutorService executor, Executor userExecutor) {
        this.id = id;
        this.coordinator = coordinator;
        this.serializer = serializer;
        this.executor = executor;
        this.userExecutor = userExecutor;
        MemberInfo localMemberInfo = new MemberInfo(coordinator.member().uri(), context.getActiveMembers().contains(coordinator.member().uri()) ? Member.Type.ACTIVE : Member.Type.PASSIVE, Member.Status.ALIVE);
        this.localMember = new CoordinatedLocalMember(id, localMemberInfo, coordinator.member(), serializer, (Executor)executor);
        this.membersInfo.put(localMemberInfo.uri(), localMemberInfo);
        ConcurrentHashMap<String, CoordinatedMember> members = new ConcurrentHashMap<String, CoordinatedMember>();
        members.put(this.localMember.uri(), this.localMember);
        for (String replica : context.getActiveMembers()) {
            if (replica.equals(this.localMember.uri())) continue;
            MemberCoordinator memberCoordinator = coordinator.member(replica);
            if (memberCoordinator != null) {
                members.put(replica, new CoordinatedMember(id, new MemberInfo(replica, Member.Type.ACTIVE, Member.Status.ALIVE), memberCoordinator, serializer, executor));
                continue;
            }
            throw new ClusterException("Invalid replica " + replica, new Object[0]);
        }
        this.members = new CoordinatedMembers(members, this);
        this.router = router;
        this.context = context;
        try {
            executor.submit(() -> {
                this.thread = Thread.currentThread();
                return this.thread;
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ClusterException(e);
        }
    }

    @Override
    public synchronized void update(Observable o, Object arg) {
        RaftContext context = (RaftContext)o;
        if (!(context.getLeader() == null || this.electedLeader != null && this.electedLeader.equals(context.getLeader()))) {
            this.electedLeader = context.getLeader();
            MemberManager member = this.member(context.getLeader());
            if (member != null) {
                ElectionEvent event = new ElectionEvent(ElectionEvent.Type.COMPLETE, context.getTerm(), member);
                for (EventListener<ElectionEvent> listener : this.electionListeners) {
                    listener.accept(event);
                }
            }
        }
    }

    private void checkThread() {
        if (Thread.currentThread() != this.thread) {
            throw new IllegalStateException("Cluster not running on the correct thread");
        }
    }

    private void sendJoins() {
        this.sendJoins(this.getGossipMembers());
    }

    private void sendJoins(Collection<CoordinatedMember> gossipMembers) {
        this.checkThread();
        this.localMember.info().version(this.localMember.info().version() + 1L);
        ArrayList<MemberInfo> members = new ArrayList<MemberInfo>(this.membersInfo.values());
        for (CoordinatedMember member : gossipMembers) {
            if (member.uri().equals(this.member().uri())) continue;
            member.send(JOIN_TOPIC, this.id, members, this.internalSerializer, this.executor).whenCompleteAsync((membersInfo, error) -> {
                this.checkThread();
                if (this.isOpen()) {
                    if (error == null) {
                        member.info().succeed();
                        this.updateMemberInfo((Collection<MemberInfo>)membersInfo);
                    } else {
                        member.info().fail(this.localMember.uri());
                    }
                }
            }, (Executor)this.executor);
        }
    }

    private CompletableFuture<Collection<MemberInfo>> handleJoin(Collection<MemberInfo> members) {
        this.checkThread();
        this.localMember.info().version(this.localMember.info().version() + 1L);
        this.updateMemberInfo(members);
        return CompletableFuture.completedFuture(new ArrayList<MemberInfo>(this.membersInfo.values()));
    }

    private void updateMemberInfo(Collection<MemberInfo> membersInfo) {
        this.checkThread();
        membersInfo.forEach(memberInfo -> {
            MemberInfo info = this.membersInfo.get(memberInfo.uri());
            if (info == null) {
                info = memberInfo;
                this.membersInfo.put(memberInfo.uri(), (MemberInfo)memberInfo);
            } else {
                info.update((MemberInfo)memberInfo);
            }
            MemberInfo updatedInfo = info;
            if (updatedInfo.state() == Member.Status.ALIVE || updatedInfo.state() == Member.Status.SUSPICIOUS) {
                Map<String, CoordinatedMember> map = this.members.members;
                synchronized (map) {
                    CoordinatedMember member;
                    if (!this.members.members.containsKey(updatedInfo.uri()) && (member = this.createMember(updatedInfo)) != null) {
                        this.members.members.put(member.uri(), member);
                        this.context.addMember(member.uri());
                        this.LOGGER.info("{} - {} joined the cluster", (Object)this.context.getLocalMember(), (Object)member.uri());
                        this.membershipListeners.forEach(listener -> listener.accept(new MembershipEvent(MembershipEvent.Type.JOIN, member)));
                        this.sendJoins(this.members.members.values());
                    }
                }
            }
            Map<String, CoordinatedMember> map = this.members.members;
            synchronized (map) {
                CoordinatedMember member = this.members.members.remove(updatedInfo.uri());
                if (member != null) {
                    this.context.removeMember(member.uri());
                    this.LOGGER.info("{} - {} left the cluster", (Object)this.context.getLocalMember(), (Object)member.uri());
                    this.membershipListeners.forEach(listener -> listener.accept(new MembershipEvent(MembershipEvent.Type.LEAVE, member)));
                    this.sendJoins(this.members.members.values());
                }
            }
        });
        this.cleanMemberInfo();
    }

    protected abstract CoordinatedMember createMember(MemberInfo var1);

    private synchronized void cleanMemberInfo() {
        this.checkThread();
        Iterator<Map.Entry<String, MemberInfo>> iterator = this.membersInfo.entrySet().iterator();
        while (iterator.hasNext()) {
            MemberInfo info = iterator.next().getValue();
            if (info.state() != Member.Status.DEAD || System.currentTimeMillis() <= info.changed() + 60000L) continue;
            iterator.remove();
        }
    }

    /*
     * Exception decompiling
     */
    private Collection<CoordinatedMember> getGossipMembers() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public MemberManager leader() {
        return this.context.getLeader() != null ? this.member(this.context.getLeader()) : null;
    }

    @Override
    public long term() {
        return this.context.getTerm();
    }

    @Override
    public MemberManager member(String uri) {
        return this.members.members.get(uri);
    }

    @Override
    public LocalMemberManager member() {
        return this.localMember;
    }

    @Override
    public Members members() {
        return this.members;
    }

    @Override
    public synchronized <T> Cluster broadcast(String topic, T message) {
        for (Member member : this.members) {
            member.send(topic, message);
        }
        return this;
    }

    @Override
    public synchronized <T> Cluster addBroadcastListener(String topic, EventListener<T> listener) {
        this.broadcastListeners.computeIfAbsent(topic, t -> new CopyOnWriteArraySet()).add(listener);
        if (!this.broadcastHandlers.containsKey(topic)) {
            MessageHandler handler = message -> {
                this.broadcastListeners.get(topic).forEach(l -> l.accept(message));
                return CompletableFuture.completedFuture(null);
            };
            this.broadcastHandlers.put(topic, handler);
            this.member().registerHandler(topic, handler);
        }
        return this;
    }

    @Override
    public synchronized <T> Cluster removeBroadcastListener(String topic, EventListener<T> listener) {
        Set<EventListener> listeners = this.broadcastListeners.get(topic);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.broadcastListeners.remove(topic);
                this.broadcastHandlers.remove(topic);
                this.member().unregisterHandler(topic);
            }
        }
        return this;
    }

    @Override
    public Cluster addMembershipListener(EventListener<MembershipEvent> listener) {
        this.membershipListeners.add(listener);
        return this;
    }

    @Override
    public Cluster removeMembershipListener(EventListener<MembershipEvent> listener) {
        this.membershipListeners.remove(listener);
        return this;
    }

    @Override
    public Cluster addElectionListener(EventListener<ElectionEvent> listener) {
        this.electionListeners.add(listener);
        return this;
    }

    @Override
    public Cluster removeElectionListener(EventListener<ElectionEvent> listener) {
        this.electionListeners.remove(listener);
        return this;
    }

    @Override
    public synchronized CompletableFuture<ClusterManager> open() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> {
            this.router.createRoutes(this, this.context);
            this.context.addObserver(this);
        }, this.executor).thenCompose(v -> this.localMember.open())).thenRun(() -> this.localMember.registerHandler(JOIN_TOPIC, this.id, this::handleJoin, this.internalSerializer, this.executor))).thenRun(() -> {
            this.gossipTimer = this.executor.scheduleAtFixedRate(this::sendJoins, 0L, 1L, TimeUnit.SECONDS);
        })).thenApply(m -> this);
    }

    @Override
    public boolean isOpen() {
        return this.localMember.isOpen();
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        this.localMember.close();
        this.router.destroyRoutes(this, this.context);
        this.context.deleteObserver(this);
        this.localMember.unregisterHandler(JOIN_TOPIC, this.id);
        if (this.gossipTimer != null) {
            this.gossipTimer.cancel(false);
            this.gossipTimer = null;
        }
        return this.localMember.close();
    }

    @Override
    public boolean isClosed() {
        return this.localMember.isClosed();
    }

    public String toString() {
        return String.format("%s[members=%s]", this.getClass().getSimpleName(), this.members());
    }

    private /* synthetic */ boolean lambda$getGossipMembers$5(CoordinatedMember member) {
        return !member.uri().equals(this.localMember.uri()) && this.localMember.type() == Member.Type.ACTIVE && member.type() == Member.Type.PASSIVE || this.localMember.type() == Member.Type.PASSIVE && member.type() == Member.Type.ACTIVE && (member.state() == Member.Status.SUSPICIOUS || member.state() == Member.Status.ALIVE);
    }
}

